/*	readdir()					Author: Kees J. Bot
 *								24 Apr 1989
 */
#define nil 0
#include <minix/stubs.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <limits.h>
#include <errno.h>
#include <string.h>

#define v7ent(p)	((struct _v7_direct *) (p))

struct dirent *readdir(DIR *dp)
/* Return the next entry in a directory.  Handle V7 and FLEX format dirs. */
{
	struct dirent *e;

	if (dp == nil) { errno= EBADF; return nil; }

	do {
		if (dp->_count <= 0) {
			/* Read the next directory block. */
			dp->_count= read(dp->_fd, dp->_buf, sizeof(dp->_buf));
			if (dp->_count <= 0) return nil;

			dp->_count/= sizeof(dp->_buf[0]);
			dp->_ptr= dp->_buf;

			/* Extent is zero of the first flex entry. */
			if (dp->_v7 == (char)-1) dp->_v7= dp->_buf[0].d_extent;
		}

		if (!dp->_v7) {
			/* FLEX. */
			e= (struct dirent *) dp->_ptr;
		} else {
			/* V7: transform to FLEX. */
			e= (struct dirent *) dp->_v7f;
			e->d_ino= v7ent(dp->_ptr)->d_ino;
			e->d_extent= 1;
			memcpy(e->d_name, v7ent(dp->_ptr)->d_name, 14);
			e->d_name[14]= 0;
		}

		dp->_ptr+= 1 + e->d_extent;
		dp->_count-= 1 + e->d_extent;
		dp->_pos+= (1 + e->d_extent) * sizeof(*dp->_ptr);

	} while (e->d_ino == 0);
	return e;
}

/*
 * $PchId: _readdir.c,v 1.4 1995/11/27 20:11:59 philip Exp $
 */
