/*	fpathconf(), pathconf() - query file system limits
 *							Author: Kees J. Bot
 *								25 Jan 1994
 *
 * (F)pathconf returns the current file system limits, like the maximum number
 * of links that can be made to a file.  These values need not be the same
 * on the next invocation of the program, although under Minix they are.
 */

#define _POSIX_SOURCE

#include <limits.h>
#include <unistd.h>
#include <termios.h>
#include <sys/stat.h>
#include <errno.h>

long _pconf(struct stat *stp, int name)
/* Called by fpathconf() or pathconf() with the stat(2) information on file
 * descriptor or pathname.
 */
{
	static struct pathconf {
		int	name;
		long	value;
	} conf[]= {
		{ _PC_LINK_MAX,		LINK_MAX  /* Only 1 for a dir */ },
		{ _PC_MAX_CANON,	MAX_CANON	},
		{ _PC_MAX_INPUT,	MAX_INPUT	},
		{ _PC_NAME_MAX,		NAME_MAX	},
		{ _PC_PATH_MAX,		PATH_MAX	},
		{ _PC_PIPE_BUF,		PIPE_BUF	},
		{ _PC_NO_TRUNC,		0		},
		{ _PC_VDISABLE,		_POSIX_VDISABLE	},
		{ _PC_CHOWN_RESTRICTED,	1		},
	};
	struct pathconf *pc;

	/* Max links depends on the file type. */
	conf[0].value= S_ISDIR(stp->st_mode) ? 1 : LINK_MAX;

	for (pc= conf; pc < conf + sizeof(conf)/sizeof(conf[0]); pc++) {
		if (pc->name == name) return pc->value;
	}

	errno= EINVAL;
	return -1;
}

/*
 * $PchId: _pconf.c,v 1.3 1995/11/27 20:12:05 philip Exp $
 */
