/*
usleep.c

Created:	Mar 15, 1993 by Philip Homburg

implement usleep on top of u_sleep
*/

#define _MINIX_SOURCE

#include <minix/stubs.h>
#include <sys/types.h>
#include <errno.h>
#include <time.h>
#include <unistd.h>

void usleep(usecs)
unsigned long usecs;
{
	struct timeval tv;
	int r;

	if (sysutime(UTIME_TIMEOFDAY, &tv) == -1)
		return;
	tv.tv_sec += usecs / 1000000;
	tv.tv_usec += usecs % 1000000;
	if (tv.tv_usec >= 1000000)
	{
		tv.tv_sec++;
		tv.tv_usec -= 1000000;
	}

	for (;;)
	{
		r= u_sleep(&tv);
		if (r == -1 && errno == EINTR)
			continue;
		break;
	}
}

/*
 * $PchId: usleep.c,v 1.4 1995/11/27 20:17:41 philip Exp $
 */
