/*	getmntent(3) - get an mtab entry		Author: Kees J. Bot
 *								15 Nov 1992
 */
#include <stdio.h>
#include <sys/mnttab.h>

#define arraysize(a)		(sizeof(a) / sizeof((a)[0]))
#define arraylimit(a)		((a) + arraysize(a))

#define skipword(pp)	(*(pp)= skipw(*(pp)))
/* Skip a word and transform whitespace to nulls. */

static char *skipw(char *p)
{
	while (*p != 0 && *p != ' ') p++;
	while (*p == ' ') *p++= 0;
	return p;
}

int getmntent(FILE *mfp, struct mnttab *mtp)
/* Read one entry of a mount table into a struct mnttab. */
{
	static char mntline[MNT_LINE_MAX];
	char *mp;
	int c;
	int r= 0;

	do {
		/* Skip leading whitespace. */
		while ((c= fgetc(mfp)) != EOF && c <= ' ') {}

		/* Read one line. */
		mp= mntline;

		while (c != EOF && c != '\n' && c != '#') {
			if (c <= ' ') c= ' ';
			if (mp < arraylimit(mntline)) *mp++ = c;
			c= fgetc(mfp);
		}

		/* Skip comment. */
		if (c == '#') while ((c= fgetc(mfp)) != EOF && c != '\n') {}

		/* Return -1 on EOF. */
		if (c == EOF) return -1;

	} while (mp == mntline);	/* Until nonempty. */

	if (mp == arraylimit(mntline)) { mp--; r= MNT_TOOLONG; }
	*mp= 0;
	mp= mntline;

	/* Fill the struct. */
	mtp->mnt_special= mp;	skipword(&mp);
	mtp->mnt_mountp= mp;	skipword(&mp);
	mtp->mnt_fstype= mp;	skipword(&mp);
	mtp->mnt_mntopts= mp;	skipword(&mp);
	mtp->mnt_freq= mp;	skipword(&mp);
	mtp->mnt_fsckpass= mp;	skipword(&mp);
	mtp->mnt_time= mp;	skipword(&mp);

	if (r != 0) return r;
	if (mtp->mnt_time[0] == 0) return MNT_TOOFEW;
	if (*mp != 0) return MNT_TOOMANY;
	return 0;
}

/*
 * $PchId: getmntent.c,v 1.3 1995/11/27 20:22:44 philip Exp $
 */
