/*	getmntany(3) - search for an or mtab entry	Author: Kees J. Bot
 *								15 Dec 1992
 */
#define nil 0
#include <minix/stubs.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mnttab.h>

int _spec_equal(const char *mspec, const char *lspec)
/* Devices are equal if their device numbers match. */
{
	struct stat mst, lst;

	return lspec == nil
		|| (	stat(mspec, &mst) >= 0
			&& stat(lspec, &lst) >= 0
			&& S_ISBLK(mst.st_mode)
			&& S_ISBLK(lst.st_mode)
			&& mst.st_rdev == lst.st_rdev
		);
}

int _mountp_equal(const char *mdir, const char *ldir)
/* Mountpoints are equal if they are the same file (obviously.) */
{
	struct stat mst, lst;

	return ldir == nil
		|| (	stat(mdir, &mst) >= 0
			&& stat(ldir, &lst) >= 0
			&& mst.st_dev == lst.st_dev
			&& mst.st_ino == lst.st_ino
		);
}

int _fstype_equal(const char *mtype, const char *ltype)
/* The type "dev" matches "1", "2", "1f", and "2f" too. */
{
	return ltype == nil
		|| strcmp(mtype, ltype) == 0
		|| (	strcmp(ltype, "dev") == 0
			&& (unsigned) (mtype[0] - '1') < 2
			&& (	mtype[1] == 0
				|| (mtype[1] == 'f' && mtype[2] == 0)
			)
		);
}

int getmntany(FILE *mfp, struct mnttab *mtp, const struct mnttab *look)
/* Hunt for an mtab entry that looks like "look".  Limited on purpose to
 * the first three fields.  (See the manual page why).
 */
{
	int r;

	while ((r= getmntent(mfp, mtp)) >= 0) {
		if (_spec_equal(mtp->mnt_special, look->mnt_special)
			&& _mountp_equal(mtp->mnt_mountp, look->mnt_mountp)
			&& _fstype_equal(mtp->mnt_fstype, look->mnt_fstype)
		) break;
	}
	return r;
}

/*
 * $PchId: getmntany.c,v 1.4 1995/11/27 20:23:08 philip Exp $
 */
