/*
errno/errlist.c

Created:	June 29, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#include	"errlist.h"

const struct errlist __sys_errlist[] = {
	/* UNIX V7 errors */
	{ "Not owner",			EPERM		},
	{ "No such file or directory",	ENOENT		},
	{ "No such process",		ESRCH		},
	{ "Interrupted system call",	EINTR		},
	{ "I/O error",			EIO		},
	{ "No such device or address",	ENXIO		},
	{ "Arg list too long",		E2BIG		},
	{ "Exec format error",		ENOEXEC		},
	{ "Bad file number",		EBADF		},
	{ "No children",		ECHILD		},
	{ "Resource temporarily unavailable",EAGAIN	},
	{ "Not enough core",		ENOMEM		},
	{ "Permission denied",		EACCES		},
	{ "Bad address",		EFAULT		},
	{ "Block device required",	ENOTBLK		},
	{ "Resource busy",		EBUSY		},
	{ "File exists",		EEXIST		},
	{ "Cross-device link",		EXDEV		},
	{ "No such device",		ENODEV		},
	{ "Not a directory",		ENOTDIR		},
	{ "Is a directory",		EISDIR		},
	{ "Invalid argument",		EINVAL		},
	{ "File table overflow",	ENFILE		},
	{ "Too many open files",	EMFILE		},
	{ "Not a typewriter",		ENOTTY		},
	{ "Text file busy",		ETXTBSY		},
	{ "File too large",		EFBIG		},
	{ "No space left on device",	ENOSPC		},
	{ "Illegal seek",		ESPIPE		},
	{ "Read-only file system",	EROFS		},
	{ "Too many links",		EMLINK		},
	{ "Broken pipe",		EPIPE		},
	{ "Math argument",		EDOM		},
	{ "Result too large",		ERANGE		},

	/* POSIX errors */
	{ "Resource deadlock avoided",	EDEADLK		},
	{ "File name too long",		ENAMETOOLONG	},
	{ "No locks available",		ENOLCK		},
	{ "Function not implemented",	ENOSYS		},
	{ "Directory not empty",	ENOTEMPTY	},
	{ "Too many symbolic links",	ELOOP		},

	/* Tcpip errors */
	{ "Invalid packet size",	EPACKSIZE	},
	{ "Not enough buffers left",	EOUTOFBUFS	},
	{ "Illegal ioctl for device",	EBADIOCTL	},
	{ "Bad mode for ioctl",		EBADMODE	},
	{ "Would block",		EWOULDBLOCK	},
	{ "Bad destination address",	EBADDEST	},
	{ "Destination not reachable",	EDSTNOTRCH	},
	{ "Already connected",		EISCONN		},
	{ "Address in use",		EADDRINUSE	},
	{ "Connection refused",		ECONNREFUSED	},
	{ "Connection reset",		ECONNRESET	},
	{ "Connection timed out",	ETIMEDOUT	},
	{ "Urgent data present",	EURG		},
	{ "No urgent data present",	ENOURG		},
	{ "No connection",		ENOTCONN	},
	{ "Already shutdown",		ESHUTDOWN	},
	{ "No such connection",		ENOCONN		},

	/* following errors are for asynchronous I/O */
	{ "Operation now in progress",	EINPROGRESS	},
	{ "Operation already in progress",EALREADY	},

	/* Minix errors */
	{ "Can't send message",		ELOCKED		},
	{ "Error on send/receive",	EBADCALL	},

	/* End of list */
	{ NULL,				0		},
};

/*
 * $PchId: errlist.c,v 1.4 1995/11/27 20:28:18 philip Exp $
 */
