.sect .text;.sect .rom;.sect .data;.sect .bss

! catchsig.s

	.define __begsig

.sect .text
	.align	4
__begsig:
	push	ebp
	mov	ebp, esp		! setup normal stackframe.
	pushad				! save registers (32 bytes)
	push	ds
	push	es
	push	fs
	push	gs
	mov	eax, 4(ebp)		! signal number from stack before save
	mov	ebx, 8(ebp)		! DEBUG, store pc.
	mov	4(ebp), ebx
	push	eax			! is argument to signal handler
	call	__vectab-4(eax*4)	! index is signal number - 1
	pop	eax			! discard signal number argument
	pop	gs			! restore registers
	pop	fs
	pop	es
	pop	ds
	popad
	pop	ebp
	add	esp, 4			! discard signal number again
	iretd

.sect .data
	.extern	__vectab

! $PchId: catchsig.ack.s,v 1.3 1996/02/23 08:23:39 philip Exp $
