#
! This is the C run-time start-off routine.  It`s job is to take the
! arguments as put on the stack by EXEC, and to parse them and set them up the
! way _main expects them.
! It also initializes _environ when this variable isn`t defined by the
! programmer.  The detection of whether _environ belong to us is rather
! simplistic.  We simply check for some magic value, but there is no other
! way.

.sect .text; .sect .rom; .sect .data; .sect .bss

.define crtso, ___main, __penvp, ___progname, __fpu_present
.extern _main, _exit
.sect .text
crtso:
	pushf				! Turn alignment checks on or off?
#if __ACK__
	orb	2(esp), 0x04		! ACK code respects alignment rules
#endif
#if __GNUC__
	andb	2(esp), ~0x04		! GNU code should, but not right now
#endif
	popf
	xor     ebp, ebp		! clear for backtrace of core files
	mov     eax, (esp)		! argc
	lea     edx, 4(esp)		! argv
	lea     ecx, 8(esp)(eax*4)	! envp

	mov	(__penvp), ecx		! save envp in __penvp

	! Store argv[0] in ___progname
	mov	ebx, (edx)
	mov	(___progname), ebx

	! Test if environ is in the initialized data area and is set to our
	! magic number.  If so then it is not redefined by the user.
	mov	ebx, _environ
	cmp	ebx, __edata
	jae	0f
	cmp	(ebx), 0x53535353	! is it our environ?
	jne	0f
	mov	(ebx), ecx		! environ = _penvp;
0:
	push	ecx			! push environ
	push	edx			! push argv
	push	eax			! push argc

	! Test the EM bit of the MSW to determine if an FPU is present and
	! set __fpu_present if one is found.
	smsw	ax
	testb	al, 0x4			! EM bit in MSW
	setz	al			! True if not set
	movb	(__fpu_present), al

	call	_main			! main(argc, argv, envp)

	push	eax			! push exit status
	call	_exit

	hlt				! force a trap if exit fails

___main:				! for GCC
	ret

.sect .rom
	.data4	0			! Without -uzp, with -sep: *NULL == 0
					! Also keeps the first string in the
					! program from appearing at location 0!
.sect .bss
	.comm	__penvp, 4		! Environment vector
	.comm	__fpu_present, 4	! FPU present flag
	.comm	___progname, 4		! argv[0]

! $PchId: crtso.ack.s,v 1.6 1996/03/01 09:44:37 philip Exp $
