! Some I/O related routines like:
!	unsigned u8_t inb(u16_t port);
!	unsigned u16_t inw(u16_t port);
!	unsigned u32_t inl(u16_t port);
!	void outb(u16_t port, u8_t value);
!	void outw(u16_t port, u16_t value);
!	void outl(u16_t port, u32_t value);
!	void rep_inb(u16_t port, unsigned u8_t *buf, size_t count);
!	void rep_inw(u16_t port, unsigned u16_t *buf, size_t count);
!	void rep_inl(u16_t port, unsigned u32_t *buf, size_t count);
!	void rep_outb(u16_t port, unsigned u8_t *buf, size_t count);
!	void rep_outw(u16_t port, unsigned u16_t *buf, size_t count);
!	void rep_outl(u16_t port, unsigned u32_t *buf, size_t count);
!	void intr_enable(void);
!	void intr_disable(void);

.sect .text; .sect .rom; .sect .data; .sect .bss

.sect .text
.define _inb
_inb:
	push	bp
	mov	bp, sp
	mov	dx, 4(bp)		! port
	inb	dx			! read 1 byte
	xorb	ah, ah
	pop	bp
	ret

.define _inw
_inw:
	push	bp
	mov	bp, sp
	mov	dx, 4(bp)		! port
	in	dx			! read 1 word
	pop	bp
	ret

.define _outb
_outb:
	push	bp
	mov	bp, sp
	mov	dx, 4(bp)		! port
	mov	ax, 4+2(bp)		! value
	outb	dx			! output 1 byte
	pop	bp
	ret

.define _outw
_outw:
	push	bp
	mov	bp, sp
	mov	dx, 4(bp)		! port
	mov	ax, 4+2(bp)		! value
	out	dx			! output 1 word
	pop	bp
	ret

.define _rep_inb
_rep_inb:
	push	bp
	mov	bp, sp
	cld
	push	di
	mov	dx, 4(bp)		! port
	mov	di, 6(bp)		! buf
	mov	cx, 8(bp)		! byte count
    rep	inb	dx			! input many bytes
	pop	di
	pop	bp
	ret

.define _rep_inw
_rep_inw:
	push	bp
	mov	bp, sp
	cld
	push	di
	mov	dx, 4(bp)		! port
	mov	di, 6(bp)		! buf
	mov	cx, 8(bp)		! byte count
	shr	cx, 1			! word count
    rep	in	dx			! input many words
	pop	di
	pop	bp
	ret

.define _rep_outb
_rep_outb:
	push	bp
	mov	bp, sp
	cld
	push	si
	mov	dx, 4(bp)		! port
	mov	si, 6(bp)		! buf
	mov	cx, 8(bp)		! byte count
    rep	outb	dx			! output many bytes
	pop	si
	pop	bp
	ret

.define _rep_outw
_rep_outw:
	push	bp
	mov	bp, sp
	cld
	push	si
	mov	dx, 4(bp)		! port
	mov	si, 6(bp)		! buf
	mov	cx, 8(bp)		! byte count
	shr	cx, 1			! word count
    rep	out	dx			! output many words
	pop	si
	pop	bp
	ret

.define _intr_disable
_intr_disable:
	push	bp
	mov	bp, sp
	cli
	pop	bp
	ret

.define _intr_enable
_intr_enable:
	push	bp
	mov	bp, sp
	sti
	pop	bp
	ret

! $PchId: iolib.ack.s,v 1.3 1996/02/23 08:27:48 philip Exp $
