!	Doscrtso.s 1.0 - DOS runtime support		Author: Kees J. Bot
!								4 May 1996
! This file contains the runtime startoff and "system call"
! support to cross-compile programs to run under MS-DOS.  The result is
! a .COM file, or what Minix calls a common I&D program.
!
.sect .text; .sect .rom; .sect .data; .sect .bss

.sect .text

.define __PSP
__PSP:
	.space	256			! Program Segment Prefix

doscrtso:
	cld				! C compiler wants UP
	xor	ax, ax			! Zero
	mov	di, _edata		! Start of bss is at end of data
	mov	cx, _end		! End of bss (begin of heap)
	sub	cx, di			! Number of bss bytes
	shr	cx, 1			! Number of words
 rep	stos				! Clear bss

	xor	cx, cx			! cx = argc
	xor	bx, bx
	push	bx			! argv[argc] = NULL
	movb	bl, (_PSP+0)		! Argument byte count
	xorb	bh, bh
0:	movb	__PSP+0x81(bx), ch	! Null terminate
	dec	bx
	js	9f
	cmpb	__PSP+0x81(bx), 0x20	! Whitespace?
	jbe	0b
1:	dec	bx			! One argument character
	js	2f
	cmpb	__PSP+0x81(bx), 0x20	! More argument characters?
	ja	1b
2:	lea	ax, __PSP+0x81+1(bx)	! Address of argument
	push	ax			! argv[n]
	inc	cx			! argc++;
	test	bx, bx
	jns	0b			! Null more whitespace
9:	movb	__PSP+0x81(bx), ch	! One more null string
	lea	ax, __PSP+0x81(bx)
	push	ax			! to use as argv[0]
	inc	cx			! Final value of argc
	mov	ax, sp
	push	ax			! argv
	push	cx			! argc
	call	_main			! main(argc, argv)
	push	ax
	call	_exit			! exit(main(argc, argv))

! DOS offers various calls that are clones of UNIX system calls.  This makes
! it relatively easy to redefine the system calls that Minix programs require.

	O_RDONLY  =	0x0000		! Various Minix include file constants
	O_WRONLY  =	0x0001
	O_RDWR	  =	0x0002
	O_ACCMODE =	0x0003
	O_CREAT	  =	0x0100
	O_EXCL	  =	0x0200
	O_TRUNC	  =	0x1000
	O_APPEND  =	0x2000

	EINVAL	  =
	EEXIST	  =
	ENOENT	  =

! int open(const char *path, int oflag, mode_t mode)
!	Open a file.  Tricky, because DOS has the old V7 open()/creat() calls.
.define _open, __open
_open:
__open:
	push	bp
	mov	bp, sp

	mov	ax, 6(bp)		! Open flags, O_RDONLY, O_CREAT, etc.
	test	ax, O_APPEND
	jz	0f
	mov	(_errno), EINVAL	! O_APPEND not implemented yet
	mov	ax, -1
	jmp	9f

0:	mov	dx, 4(bp)		! Filename
	andb	al, O_ACCMODE
	movb	ah, 0x3D		! "OPEN"
	int	0x21			! bx = open(path, oflag & O_ACCMODE);
	jc	0f
	mov	bx, ax			! Open succeeded
	mov	ax, 6(bp)		! ax = oflag
	test	ax, O_EXCL		! File should not exist if O_EXCL
	jz	1f
	movb	ah, 0x3E		! "CLOSE"
	int	0x21			! close(bx);
	mov	ax, EEXIST
	jmp	8f
1:	test	ax, O_TRUNC		! Should have truncated file?
	jnz	1f
	mov	ax, bx			! No, return file handle
	jmp	9f
1:	movb	ah, 0x3E		! "CLOSE"
	int	0x21			! close(bx);
	jmp	1f			! Go truncate file
0:
	cmp	ax, ENOENT		! Open failed, expect ENOENT
	jne	8f
	mov	bx, 6(bp)		! ax = oflag
	test	bx, O_CREAT		! File doesn't exist, create?
	jz	8f
1:
	mov	dx, 4(bp)		! Filename
	xor	cx, cx			! Ignore mode, always read-write
	movb	ah, 0x3C		! "CREAT"
	int	0x21			! ax = creat(path, 0666);
	jc	8f
	mov	bx, 6(bp)
	andb	bl, O_ACCMODE
	cmpb	bl, O_WRONLY		! (oflags & O_ACCMODE) == O_WRONLY?
	je	9f			! File handle is fine for write-only

	mov	bx, ax			! bx = file handle
	movb	ah, 0x3E		! "CLOSE"
	int	0x21			! close(bx);

	mov	dx, 4(bp)
	mov	ax, 6(bp)
	andb	al, O_ACCMODE
	movb	ah, 0x3D		! "OPEN"
	int	0x21			! ax = open(path, oflag & O_ACCMODE);
	jnc	9f

8:	mov	(_errno), ax
	mov	ax, -1
9:	pop	bp
	ret

! int creat(const char *path, mode_t mode)
!	Create a file with the old creat() call.
.define _creat, __creat
_creat:
__creat:
	mov	bx, sp
	mov	dx, 2(bx)		! Filename
	xor	cx, cx			! Ignore mode, always read-write
	movb	ah, 0x3C		! "CREAT"
dos:	int	0x21			! ax = creat(path, 0666);
dosret:	jnc	9f
8:	mov	(_errno), ax
	mov	ax, -1
	mov	dx, ax
9:	ret

! int close(int fd)
!	Close an open file.
.define _close, __close
_close:
__close:
	mov	bx, sp
	mov	bx, 2(bx)		! bx = file handle
	movb	ah, 0x3E		! "CLOSE"
	jmp	dos


! int fcntl(int fd, int cmd, ...)
! int chmod(const char *path, mode_t mode)
!	Unimplemented calls.
.define _fcntl, __fcntl, _chmod, __chmod, _ioctl, __ioctl
_fcntl:
__fcntl:
_chmod:
__chmod:
_ioctl:
__ioctl:
	mov	(_errno), EINVAL
	mov	ax, -1
	ret

! void _exit(int status)
!	Return to DOS.
.define __exit, ___exit
__exit:
___exit:
	pop	ax
	pop	ax			! al = status
	movb	ah, 0x4C		! "EXIT"
	int	0x21

! int mkdir(const char *path)
!	Make a directory.
.define _mkdir, __mkdir
_mkdir:
__mkdir:
	mov	bx, sp
	mov	dx, 2(bx)
	movb	ah, 0x39		! "MKDIR"
	jmp	dos

! int rmdir(const char *path)
!	Remove a directory.
.define _rmdir, __rmdir
_rmdir:
__rmdir:
	mov	bx, sp
	mov	dx, 2(bx)
	movb	ah, 0x3A		! "RMDIR"
	jmp	dos

! int chdir(const char *path)
!	Set current working directory.
.define _chdir, __chdir
_chdir:
__chdir:
	mov	bx, sp
	mov	bx, 2(bx)
	movb	dl, (bx)
	subb	dl, 0x41
	cmpb	dl, 26			! 'A' <= path[0] && path[0] <= 'Z'?
	jb	0f
	movb	dl, (bx)
	subb	dl, 0x61
	cmpb	dl, 26			! 'A' <= path[0] && path[0] <= 'Z'?
	mov	dx, 2(bx)
	jae	1f
0:	cmpb	1(bx), 0x3A		! path[1] == ':'?
	jne	1f
	movb	ah, 0x0E		! "Select default drive"
	int	0x21
	lea	bx, 2(bx)		! Skip drive letter and colon
1:	mov	dx, bx
	movb	ah, 0x3B		! "CHDIR"
	jmp	dos

! ssize_t read(int fd, void *buf, size_t n)
!	Read bytes from an open file.
.define _read, __read
_read:
__read:
	mov	bx, sp
	mov	cx, 6(bx)
	mov	dx, 4(bx)
	mov	bx, 2(bx)
	movb	ah, 0x3F		! "READ"
	jmp	dos

! ssize_t write(int fd, const void *buf, size_t n)
!	Write bytes from an open file.
.define _write, __write
_write:
__write:
	mov	bx, sp
	mov	cx, 6(bx)
	mov	dx, 4(bx)
	mov	bx, 2(bx)
	movb	ah, 0x40		! "WRITE"
	jmp	dos

! int unlink(const char *path)
!	Remove a file.
.define _unlink, __unlink
_unlink:
__unlink:
	mov	bx, sp
	mov	dx, 2(bx)
	movb	ah, 0x41		! "UNLINK"
	jmp	dos

! off_t lseek(int fd, off_t offset, int whence)
!	Set file position for read or write.
.define _lseek, __lseek
_lseek:
__lseek:
	mov	bx, sp
	movb	al, 8(bx)		! SEEK_SET, SEEK_CUR, SEEK_END
	mov	dx, 4(bx)
	mov	cx, 6(bx)		! cx:dx = offset
	mov	bx, 2(bx)
	movb	ah, 0x42		! "LSEEK"
	jmp	dos

! int dup(int fd)
!	Duplicate file handle.
.define _dup, __dup
_dup:
__dup:
	mov	bx, sp
	mov	bx, 2(bx)
	movb	ah, 0x45		! "DUP"
	jmp	dos

! int dup2(int fd1, int fd2)
!	Duplicate file handle.
.define _dup2, __dup2
_dup2:
__dup2:
	mov	bx, sp
	mov	cx, 4(bx)
	mov	bx, 2(bx)
	cmp	bx, cx			! dup2(fd, fd)?
	jne	0f
	mov	ax, cx
	ret
0:	movb	ah, 0x45		! "DUP2"
	jmp	dos

! char *getcwd(char *path, size_t size)
.define _getcwd, __getcwd
_getcwd:
__getcwd:
	mov	bx, sp
	mov	ax, 4(bx)
	cmp	ax, 3+64
	jae	0f
	mov	(_errno), ERANGE
	xor	ax, ax
	ret
0:	push	si
	mov	si, 2(bx)
	lea	si, 3(si)		! si = path + 3
	xorb	dl, dl			! Current drive
	movb	ah, 0x47		! "CWD"
	int	0x21
	pop	si
	jnc	0f
	mov	(_errno), ax
	xor	ax, ax
	ret
0:	movb	ah, 0x19		! "Get current default drive"
	int	0x21
	addb	al, 0x41		! al += 'A'
	mov	bx, 2(bx)
	movb	(bx), al
	movb	1(bx), 0x3A		! path[1] = ':';
	movb	2(bx), 0x5C		! path[2] = '\\';
	mov	ax, bx
	ret

! int rename(const char *old, const char *new)
!	Rename a file.
.define _rename, __rename
_rename:
__rename:
	mov	bx, sp
	push	di
	mov	dx, 2(bx)		! Old
	mov	di, 2(bx)		! New
	movb	ah, 0x56		! "RENAME"
	int	0x21
	pop	di
	jc	dosret
	xor	ax, ax
	ret
