! Some I/O related routines like:
!	unsigned u8_t inb(u16_t port);
!	unsigned u16_t inw(u16_t port);
!	unsigned u32_t inl(u16_t port);
!	void outb(u16_t port, u8_t value);
!	void outw(u16_t port, u16_t value);
!	void outl(u16_t port, u32_t value);
!	void rep_inb(u16_t port, unsigned u8_t *buf, size_t count);
!	void rep_inw(u16_t port, unsigned u16_t *buf, size_t count);
!	void rep_inl(u16_t port, unsigned u32_t *buf, size_t count);
!	void rep_outb(u16_t port, unsigned u8_t *buf, size_t count);
!	void rep_outw(u16_t port, unsigned u16_t *buf, size_t count);
!	void rep_outl(u16_t port, unsigned u32_t *buf, size_t count);
!	void intr_enable(void);
!	void intr_disable(void);

.sect .text; .sect .rom; .sect .data; .sect .bss

.sect .text
.define _inb
_inb:
	push	ebp
	mov	ebp, esp
	mov	edx, 8(ebp)		! port
	xor	eax, eax
	inb	dx			! read 1 byte
	pop	ebp
	ret

.define _inw
_inw:
	push	ebp
	mov	ebp, esp
	mov	edx, 8(ebp)		! port
	xor	eax, eax
    o16	in	dx			! read 1 word
	pop	ebp
	ret

.define _inl
_inl:
	push	ebp
	mov	ebp, esp
	mov	edx, 8(ebp)		! port
	in	dx			! read 1 dword
	pop	ebp
	ret

.define _outb
_outb:
	push	ebp
	mov	ebp, esp
	mov	edx, 8(ebp)		! port
	mov	eax, 8+4(ebp)		! value
	outb	dx			! output 1 byte
	pop	ebp
	ret

.define _outw
_outw:
	push	ebp
	mov	ebp, esp
	mov	edx, 8(ebp)		! port
	mov	eax, 8+4(ebp)		! value
    o16	out	dx			! output 1 word
	pop	ebp
	ret

.define _outl
_outl:
	push	ebp
	mov	ebp, esp
	mov	edx, 8(ebp)		! port
	mov	eax, 8+4(ebp)		! value
	out	dx			! output 1 dword
	pop	ebp
	ret

.define _rep_inb
_rep_inb:
	push	ebp
	mov	ebp, esp
	cld
	push	edi
	mov	edx, 8(ebp)		! port
	mov	edi, 12(ebp)		! buf
	mov	ecx, 16(ebp)		! byte count
	rep
	inb	dx			! input many bytes
	pop	edi
	pop	ebp
	ret

.define _rep_inw
_rep_inw:
	push	ebp
	mov	ebp, esp
	cld
	push	edi
	mov	edx, 8(ebp)		! port
	mov	edi, 12(ebp)		! buf
	mov	ecx, 16(ebp)		! byte count
	shr	ecx, 1			! word count
	rep
    o16	in	dx			! input many words
	pop	edi
	pop	ebp
	ret

.define _rep_inl
_rep_inl:
	push	ebp
	mov	ebp, esp
	cld
	push	edi
	mov	edx, 8(ebp)		! port
	mov	edi, 12(ebp)		! buf
	mov	ecx, 16(ebp)		! byte count
	shr	ecx, 2			! dword count
	rep
	in	dx			! input many dwords
	pop	edi
	pop	ebp
	ret

.define _rep_outb
_rep_outb:
	push	ebp
	mov	ebp, esp
	cld
	push	esi
	mov	edx, 8(ebp)		! port
	mov	esi, 12(ebp)		! buf
	mov	ecx, 16(ebp)		! byte count
	rep
	outb	dx			! output many bytes
	pop	esi
	pop	ebp
	ret

.define _rep_outw
_rep_outw:
	push	ebp
	mov	ebp, esp
	cld
	push	esi
	mov	edx, 8(ebp)		! port
	mov	esi, 12(ebp)		! buf
	mov	ecx, 16(ebp)		! byte count
	shr	ecx, 1			! word count
	rep
    o16	out	dx			! output many words
	pop	esi
	pop	ebp
	ret

.define _rep_outl
_rep_outl:
	push	ebp
	mov	ebp, esp
	cld
	push	esi
	mov	edx, 8(ebp)		! port
	mov	esi, 12(ebp)		! buf
	mov	ecx, 16(ebp)		! byte count
	shr	ecx, 2			! dword count
	rep
	out	dx			! output many dwords
	pop	esi
	pop	ebp
	ret

.define _intr_disable
_intr_disable:
	push	ebp
	mov	ebp, esp
	cli
	pop	ebp
	ret

.define _intr_enable
_intr_enable:
	push	ebp
	mov	ebp, esp
	sti
	pop	ebp
	ret

! $PchId: iolib.ack.s,v 1.3 1996/02/23 08:17:59 philip Exp $

