/*
nbio_fdop.c

Created:	12 April 1994 by Philip Homburg <philip@cs.vu.nl>
*/

#include "ansi.h"
#include "nbio_int.h"

static void nbio_no_cb ARGS(( nbio_ref_t ref, int res, int err ));

DEFUN
(void nbio_register, (fd),
	int fd
)
{
	int i, index;
	u32_t mask;

	DPRINT(2, (stderr, "nbio_register(%d, ...)\n", fd));

	if (fd < 0 || fd >= SET_SIZE)
		abort();
	index= ((unsigned)fd / NFDBITS);
	mask= (1 << (fd & (NFDBITS-1)));

	/* Read and write are normally ready, there are no exceptional
	 * conditions.
	 */
	nbio_read_all.fds_bits[index] |= mask;
	nbio_write_all.fds_bits[index] |= mask;

	DPRINT(3, (stderr, "nbio_register: index= %d, mask= 0x%x\n",
		index, mask));
	DPRINT(3, (stderr,
		"nbio_register: read_all[0]= 0x%x, write_all[0]=  0x%x\n",
		nbio_read_all.fds_bits[0],
		nbio_write_all.fds_bits[0]));

	for (i= 0; i<ASIO_NR; i++)
	{
		if (nbio_ip_table[fd][i].func != 0)
			abort();
		nbio_ip_table[fd][i].func= nbio_no_cb;
	}
}

DEFUN
(void nbio_unregister, (fd),
	int fd
)
{
	int i, index;
	u32_t mask;

	DPRINT(2, (stderr, "nbio_unregister(%d)\n", fd));

	if (fd < 0 || fd >= SET_SIZE)
		abort();
	index= ((unsigned)fd / NFDBITS);
	mask= (1 << (fd & (NFDBITS-1)));

	nbio_read_all.fds_bits[index] &= ~mask;
	nbio_write_all.fds_bits[index] &= ~mask;
	nbio_except_all.fds_bits[index] &= ~mask;
	nbio_read_block.fds_bits[index] &= ~mask;
	nbio_write_block.fds_bits[index] &= ~mask;
	nbio_except_block.fds_bits[index] &= ~mask;

	for (i= 0; i<ASIO_NR; i++)
	{
		ASIO_FD_CLR(fd, i, &nbio_asio_fd_set);
		nbio_ip_table[fd][i].func= 0;
		if (nbio_ip_table[fd][i].buf != NULL)
		{
			free(nbio_ip_table[fd][i].buf);
			nbio_ip_table[fd][i].buf= NULL;
		}
	}
}

DEFUN
(void nbio_setcallback, (fd, op, func, ref),
	int fd AND
	int op AND
	nbio_cb_func_t func AND
	nbio_ref_t ref
)
{
	if (fd < 0 || fd >= SET_SIZE || op < 0 || op >= ASIO_NR)
		abort();
	if (nbio_ip_table[fd][op].buf != NULL)
		abort();
	if (func == 0)
		nbio_ip_table[fd][op].func= nbio_no_cb;
	else
		nbio_ip_table[fd][op].func= func;
	nbio_ip_table[fd][op].ref= ref;
}

DEFUN
(void nbio_inprogress, (fd, op, bl_read, bl_write, bl_except),
	int fd AND
	int op AND
	int bl_read AND
	int bl_write AND
	int bl_except
)
{
	int index;
	u32_t mask;

	DPRINT(2, (stderr, "nbio_inprogress(%d, %d, %d, %d, %d)\n",
		fd, op, bl_read, bl_write, bl_except));

	if (fd < 0 || fd >= SET_SIZE)
		abort();
	if (op < 0 || op >= ASIO_NR)
		abort();
	if (ASIO_FD_ISSET(fd, op, &nbio_asio_fd_set))
		abort();
	ASIO_FD_SET(fd, op, &nbio_asio_fd_set);
	nbio_ip_table[fd][op].bl_read= bl_read;
	nbio_ip_table[fd][op].bl_write= bl_write;
	nbio_ip_table[fd][op].bl_except= bl_except;

	index= ((unsigned)fd / NFDBITS);
	mask= (1 << (fd & (NFDBITS-1)));

	if (bl_read) nbio_read_block.fds_bits[index] |= mask;
	if (bl_write) nbio_write_block.fds_bits[index] |= mask;
	if (bl_except) nbio_except_block.fds_bits[index] |= mask;
}

DEFUN
(int nbio_isinprogress, (fd, op),
	int fd AND
	int op
)
{
	DPRINT(2, (stderr, "nbio_isinprogress(%d, %d)\n",
		fd, op));

	if (fd < 0 || fd >= SET_SIZE)
		abort();
	if (op < 0 || op >= ASIO_NR)
		abort();
	return ASIO_FD_ISSET(fd, op, &nbio_asio_fd_set);
}

DEFUN
(void nbio_completed, (fd, op),
	int fd AND
	int op
)
{
	int bl_read, bl_write, bl_except;
	int i, index;
	u32_t mask;

	DPRINT(2, (stderr, "nbio_completed(%d, %d)\n", fd, op));

	if (fd < 0 || fd >= SET_SIZE)
		abort();
	if (op < 0 || op >= ASIO_NR)
		abort();
	if (!ASIO_FD_ISSET(fd, op, &nbio_asio_fd_set))
		abort();
	ASIO_FD_CLR(fd, op, &nbio_asio_fd_set);
	nbio_ip_table[fd][op].bl_read= 0;
	nbio_ip_table[fd][op].bl_write= 0;
	nbio_ip_table[fd][op].bl_except= 0;

	bl_read= bl_write= bl_except= 0;
	for (i= 0; i<ASIO_NR; i++)
	{
		bl_read |= nbio_ip_table[fd][i].bl_read;
		bl_write |= nbio_ip_table[fd][i].bl_write;
		bl_except |= nbio_ip_table[fd][i].bl_except;
	}

	index= ((unsigned)fd / NFDBITS);
	mask= (1 << (fd & (NFDBITS-1)));

	if (!bl_read) nbio_read_block.fds_bits[index] &= ~mask;
	if (!bl_write) nbio_write_block.fds_bits[index] &= ~mask;
	if (!bl_except) nbio_except_block.fds_bits[index] &= ~mask;
}

DEFUN
(static void nbio_no_cb, (ref, res, err),
	nbio_ref_t ref AND
	int res AND
	int err
)
{
	DPRINT(2, (stderr, "nbio_no_cb(%p, %d, %d)\n", ref.ref_ptr,
		res, err));
	DPRINT(1, (stderr, "nbio_no_cb: no callback registered\n"));
	abort();
}

/*
 * $PchId: nbio_fdop.c,v 1.3 1996/02/23 07:16:05 philip Exp $
 */
