/*	asyn_write()					Author: Kees J. Bot
 *								4 Jun 1994
 */
#include "asyn.h"

ssize_t asyn_write(asynchio_t *asyn, int fd, const void *buf, size_t len)
/* Asynchronous write().  (See asyn_read()). */
{
	asynfd_t *afd;
	ssize_t result;

	asyn->asyn_more++;

	if ((unsigned) fd >= ASIO_FD_SETSIZE) { errno= EBADF; return -1; }
	afd= &asyn->asyn_afd[fd];

	if (afd->afd_op[ASIO_WRITE].aop_state == INPROGRESS) {
		ASIO_FD_SET(fd, ASIO_WRITE, &asyn->asyn_ports);
		errno= EINPROGRESS;
		asyn->asyn_more--;
		return -1;
	}

	if (afd->afd_op[ASIO_WRITE].aop_state == RESULT) {
		afd->afd_op[ASIO_WRITE].aop_state= IDLE;
		ASIO_FD_CLR(fd, ASIO_WRITE, &asyn->asyn_ports);
		errno= afd->afd_op[ASIO_WRITE].aop_errno;
		return afd->afd_op[ASIO_WRITE].aop_result;
	}

	if (!afd->afd_seen) {
		int flags;

		if ((flags= fcntl(fd, F_GETFD)) < 0) return -1;
		if (fcntl(fd, F_SETFD, flags | FD_ASYNCHIO) < 0) return -1;
		afd->afd_seen= 1;
	}

	if ((result= write(fd, buf, len)) != -1 || errno != EINPROGRESS)
		return result;

	afd->afd_op[ASIO_WRITE].aop_state= INPROGRESS;
	ASIO_FD_SET(fd, ASIO_WRITE, &asyn->asyn_ports);
	asyn->asyn_more--;
	return -1;
}

/*
 * $PchId: asyn_write.c,v 1.4 1996/02/22 20:47:38 philip Exp $
 */
