/*	asyn_wait() - wait for asynch operations	Author: Kees J. Bot
 *								4 Jun 1994
 */

#include "asyn.h"
#include <time.h>
#include <signal.h>

static fwait_t fw;

static void time_out(int sig)
{
	/* The store to fw.fw_flags is atomic with respect to fwait. */
	fw.fw_flags |= FWF_NONBLOCK;
}

int asyn_wait(asynchio_t *asyn, int flags, struct timeval *to)
/* Wait for one or more asynchronous operations to return a result. */
{
	asynop_t *aop;
	int error, r;
	struct timeval old_timer, new_timer;
	struct sigaction old_sa, new_sa;

	/* Are there more things to do before we can block? */
	if (asyn->asyn_more > 0) { asyn->asyn_more= 0; return 0; }

	fw.fw_flags= (flags & ASYN_NONBLOCK) ? FWF_NONBLOCK : 0;
	fw.fw_bits= asyn->asyn_ports.afds_bits;
	fw.fw_maxfd= ASIO_FD_SETSIZE;

	if (flags & ASYN_NONBLOCK) {
		/* No point in mixing timeouts and not blocking. */
		to= nil;
	}

	/* To wait or not to wait, that is the question. If a timeout is 
	 * specified, we try a non-blocking call first.
	 */
	if (to != nil) {
		/* First try is non-blocking. */
		fw.fw_flags |= FWF_NONBLOCK;
	}
	r= fwait(&fw);

	if (r == -1 && errno == EAGAIN && to != nil) {
		/* First try didn't give a result.  Start a timer and block.
		 */
		fw.fw_flags &= ~FWF_NONBLOCK;
		old_timer.tv_sec= old_timer.tv_usec= 0;
		sysutime(UTIME_SETALARM, &old_timer);
		new_sa.sa_handler= time_out;
		sigfillset(&new_sa.sa_mask);
		new_sa.sa_flags= 0;
		sigaction(SIGALRM, &new_sa, &old_sa);
		new_timer= *to;
		if (new_timer.tv_sec == 0)
			new_timer.tv_sec= 1;
		if (new_timer.tv_sec > old_timer.tv_sec
						&& old_timer.tv_sec != 0) {
			new_timer= old_timer;
		}
		sysutime(UTIME_SETALARM, &new_timer);
		r= fwait(&fw);
		error= errno;
		new_timer= old_timer;
		old_timer.tv_sec= old_timer.tv_usec= 0;
		sysutime(UTIME_SETALARM, &old_timer);
		sigaction(SIGALRM, &old_sa, (struct sigaction *)0);
		sysutime(UTIME_SETALARM, &new_timer);
		errno= error;
	}

	while (r == 0) {
		/* Gather one or more results. */
		aop= &asyn->asyn_afd[fw.fw_fd].afd_op[fw.fw_operation];
		aop->aop_state= RESULT;
		aop->aop_result= fw.fw_result;
		aop->aop_errno= fw.fw_errno;

		if (!(fw.fw_flags & FWF_MORE))
			break;

		r= fwait(&fw);
	}

	return r;
}

/*
 * $PchId: asyn_wait.c,v 1.4 1996/02/22 20:44:46 philip Exp $
 */
