/*	asyn_read()					Author: Kees J. Bot
 *								4 Jun 1994
 */
#include "asyn.h"

ssize_t asyn_read(asynchio_t *asyn, int fd, void *buf, size_t len)
/* Asynchronous read().  Start a read or check if an already started read
 * is finished.  Returns like a normal read or returns -1 with errno set
 * to EINPROGRESS.
 */
{
	asynfd_t *afd;
	ssize_t result;

	/* Asyn_wait() may block if this counter equals zero indicating that
	 * all of the asyn_* functions are "in progress".
	 */
	asyn->asyn_more++;

	if ((unsigned) fd >= ASIO_FD_SETSIZE) { errno= EBADF; return -1; }
	afd= &asyn->asyn_afd[fd];

	/* Is the read still in progress? */
	if (afd->afd_op[ASIO_READ].aop_state == INPROGRESS) {
		ASIO_FD_SET(fd, ASIO_READ, &asyn->asyn_ports);
		errno= EINPROGRESS;
		asyn->asyn_more--;
		return -1;
	}

	/* Asyn_wait() has seen the read end.  Return the result and errno
	 * value.
	 */
	if (afd->afd_op[ASIO_READ].aop_state == RESULT) {
		afd->afd_op[ASIO_READ].aop_state= IDLE;
		ASIO_FD_CLR(fd, ASIO_READ, &asyn->asyn_ports);
		errno= afd->afd_op[ASIO_READ].aop_errno;
		return afd->afd_op[ASIO_READ].aop_result;
	}

	/* If this is the first async call on this filedescriptor then turn
	 * it into asynchronous mode.
	 */
	if (!afd->afd_seen) {
		int flags;

		if ((flags= fcntl(fd, F_GETFD)) < 0) return -1;
		if (fcntl(fd, F_SETFD, flags | FD_ASYNCHIO) < 0) return -1;
		afd->afd_seen= 1;
	}

	/* Start the read, it may return normally or be "in progress." */
	if ((result= read(fd, buf, len)) != -1 || errno != EINPROGRESS)
		return result;

	/* Record this read as being in progress. */
	afd->afd_op[ASIO_READ].aop_state= INPROGRESS;
	ASIO_FD_SET(fd, ASIO_READ, &asyn->asyn_ports);
	asyn->asyn_more--;
	return -1;
}

/*
 * $PchId: asyn_read.c,v 1.4 1996/02/22 20:47:38 philip Exp $
 */
