:
#!/bin/sh
# @(#)conf/lib/inst.sh	1.8 8/2/92 00:15:47
# Install a file under a list of names.
#
# usage: sh inst.sh [-lsrk] [-u user] [-g group] [-m mode] [-d dir] src [dst...]
#
#    Copyright (C) 1987, 1988 Ronald S. Karr and Landon Curt Noll
#    Copyright (C) 1992  Ronald S. Karr
# 
# See the file COPYING, distributed with smail, for restriction
# and warranty information.

# Note: if -d dir is specified, then the first dst should be a relative
#	pathname.

# Don't use getopt(1), as we can't rely on it being built yet, or
# existing on the system.

# NOTE: Chopped to pieces for Minix by kjb.

usage="Usage: inst [-lsrk] [-u user] [-g group] [-m mode] [-d dir] src [dst...]"
user=
group=
mode=
symlink=
strip=
rm_old=
err=0
dstpfx=
dbg=
keep_orig=
link=true

# put /etc into path for chmod
#PATH="$PATH:/etc"

# Note:  this shell script uses case rather than test to prevent
#	 a fork/exec on systems where test is not a builtin.

# process the list of options.
# Note:  the option letters and option arguments must be separate tokens.
while : ; do
	case $# in
	0)	break;
	esac
	case "$1" in
	--)	shift; break;;
	-[ugmd])case $# in
		1)	err=1;;
		esac
		case "$1" in
		-u)	user="$2"; link=;;
		-g)	group="$2"; link=;;
		-m)	mode="$2"; link=;;
		-d)	dstpfx="$2/";;
		esac
		shift; shift;;
	-l)	symlink=true; shift;;
	-s)	strip=true; shift;;
	-r)	rm_old=true; shift;;
	-k)	keep_orig=true; shift;;
	-D)	dbg=echo; shift;;
	-*)	err=1; break;;
	*)	break;
	esac
done

# There must be more than one operand.
case $# in
0|1)	err=1;;
esac

# If an error occured, spit out a usage message.
case "$err" in
1)	echo "$usage" 1>&2
	exit 1;;
esac

# The source file is the first operand.
srcfile="$1"; shift

# When using symlinks, copy to the first dstfile, then make all
# the others a symlink to that one.
case "$symlink" in
?*)	dstfile="$1"; shift

	dst="$dstpfx$dstfile"

	if $dbg install -c${strip:+s}${link:+l} ${user:+-o} $user \
		${group:+-g} $group ${mode:+-m} $mode "$srcfile" "$dst"
	then
		:
	else
		echo "inst: could not install $dst" 1>&2
		exit 1
	fi

	# loop through the remaining operands.
	while : ; do
		case "$#" in
		0)	break;;
		esac
		case "$1" in
		-k)	keep_orig=true; shift; continue;;
		+k)	keep_orig=; shift; continue;;
		esac
		case "$1" in
		/*)	nextdst=$1; symlink=$dst;;
		*)	nextdst=$dstpfx$1; symlink=$dstfile;;
		esac
		$dbg rm -f "$nextdst"
		if $dbg ln -s "$symlink" "$nextdst"; then
			echo "$symlink symlinked to $nextdst"
		else
			echo "inst: symlink failed for $nextdst"
			err=1
		fi
		shift
	done
	exit $err
	;;
esac

# when not using symbolic links, create the first dst, then try to
# make each successive dst a hard link to the previous.  If the hard
# link fails, then copy, creating a backup file as needed.
lastdst=

while : ; do
	case $# in
	0)	break;;
	esac
	case "$1" in
	-k)	keep_orig=true; shift; continue;;
	+k)	keep_orig=; shift; continue;;
	/*)	dst="$1";;
	*)	dst="$dstpfx$1";;
	esac
	shift

	case "$lastdst" in
	?*)	# link to previous
		if $dbg install -l "$lastdst" "$dst"
		then
			echo "$lastdst linked to $dst"
			lastdst="$dst"
		else
			err=1
		fi
		continue
	esac

	# copy to the current destination
	lastdst=

	if $dbg install -c${strip:+s}${link:+l} ${user:+-o} $user \
		${group:+-g} $group ${mode:+-m} $mode "$srcfile" "$dst"
	then
		:
	else
		$dbg rm -f "$new" "$old"
		echo "inst: could not install $dst" 1>&2
		err=1
		continue
	fi
	lastdst="$dst"
done

exit $err
