#include "sysincludes.h"
#include "msdos.h"
#include "vfat.h"

/*
 * Skip drive name.  Return pointer just after the `:', or a pointer to the
 * start of the file name if there is is no drive name.
 */

char *skip_drive(char *filename)
{
	char *p;

	p = strchr(filename, ':');
	return (p == NULL || p == filename) ? filename : p + 1;
}

/*
 * Get name component of filename.  Returns pointer to static area.
 *
 * Formerly translated name to upper case; now preserves case.
 * This is because long DOS names are case sensitive, but also because we
 * want to preserve the user-specified case for the copied Unix files
 */

char *get_name(char *filename, char *ans, char *mcwd)
{
	char *s, *temp;

					/* skip drive letter */
	temp = skip_drive(filename);

					/* find the last separator */
	if ((s = strrchr(temp, '/')))
		temp = s + 1;
	if ((s = strrchr(temp, '\\')))
		temp = s + 1;

	strncpy(ans, temp, VBUFSIZE-1);
	ans[VBUFSIZE-1]='\0';

	return ans;
}

/*
 * Get the path component of the filename.
 * Doesn't alter leading separator, always strips trailing separator (unless
 * it is the path itself).
 *
 * Formerly translated name to upper case; now preserves case.
 * This is because long DOS names are case sensitive, but also because we
 * want to preserve the user-specified case for the copied Unix files
 */

char *get_path(char *filename, char *ans, char *mcwd)
{
	char *s, *end, *begin;
	char *drive, *cwddrive;
	int has_sep;

	/* skip drive letter */
	begin = skip_drive(filename);

	/* if absolute path */
	if (*begin == '/' || *begin == '\\')
		ans[0] = '\0';
	else {
		drive = get_drive(filename, mcwd);
		cwddrive = get_drive(mcwd, mcwd);

		if (!strcmp(drive, cwddrive))
			strcpy(ans, skip_drive(mcwd));
		else
			strcpy(ans, "/");

		free(drive);
		free(cwddrive);
	}

	/* find last separator */
	has_sep = 0;
	end = begin;
	if ((s = strrchr(end, '/'))) {
		has_sep++;
		end = s;
	}
	if ((s = strrchr(end, '\\'))) {
		has_sep++;
		end = s;
	}

	if(strlen(ans)+end-begin+1 > MAX_PATH){
		fprintf(stderr,"Path too long");
		cleanup_and_exit(1);
	}

	strncat(ans, begin, end - begin);
	ans[strlen(ans)+end-begin] = '\0';

	/* if separator alone, put it back */
	if (begin == end && has_sep)
		strcat(ans, "/");

	return ans;
}

/*
 * get the drive designation
 */

char *get_drive(char *filename, char *def)
{
	char *path;
	char *drive;
	char *rest;
	size_t len;

	path = filename;
	rest = skip_drive(path);
	if (rest == path) {
		path = def;
		rest = skip_drive(path);
	}
	len = rest - path;
	drive = safe_malloc(len * sizeof(drive[0]));
	len--;
	memcpy(drive, path, len);
	drive[len] = 0;
	if (len == 1) drive[0] = toupper(drive[0]);
	return drive;
}
