/* id - return uid and gid		Author: John J. Marco */

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* 		----- id.c -----					*/
/* Id - get real and effective user id and group id			*/
/* Author: John J. Marco						*/
/*	   pa1343@sdcc15.ucsd.edu					*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

#include <sys/types.h>
#include <pwd.h>
#include <grp.h>
#include <unistd.h>
#include <stdio.h>
#include <limits.h>

_PROTOTYPE(int main, (void));

int main()
{
  struct passwd *pwd;
  struct group *grp;
  int uid, gid, euid, egid;
  gid_t groups[NGROUPS_MAX];
  int ngroups;
  int g;

  uid = getuid();
  gid = getgid();
  euid = geteuid();
  egid = getegid();
  ngroups = getgroups(NGROUPS_MAX, groups);

  if ((pwd = getpwuid(uid)) == NULL)
	printf("uid=%d", uid);
  else
	printf("uid=%d(%s)", uid, pwd->pw_name);

  if ((grp = getgrgid(gid)) == NULL)
	printf(" gid=%d", gid);
  else
	printf(" gid=%d(%s)", gid, grp->gr_name);

  if (uid != euid)
	if ((pwd = getpwuid(euid)) != NULL)
		printf(" euid=%d(%s)", euid, pwd->pw_name);
	else
		printf(" euid=%d", euid);

  if (gid != egid)
	if ((grp = getgrgid(egid)) != NULL)
		printf(" egid=%d(%s)", egid, grp->gr_name);
	else
		printf(" egid=%d", egid);

  if (ngroups > 0) {
	printf(" groups=");
	for (g = 0; g < ngroups; g++) {
		if (g > 0) fputc(',', stdout);
		gid = groups[g];
		if ((grp = getgrgid(gid)) == NULL)
			printf("%d", gid);
		else
			printf("%d(%s)", gid, grp->gr_name);
	}
  }

  printf("\n");
  return(0);
}
