/*
bsd44/lib/libc/minix/utimes.c,

Implement utimes on top of utime.

Created:	May 1995 by Philip Homburg <philip@cs.vu.nl>
*/

#include <sys/time.h>
#include <utime.h>

int utimes(const char *name, const struct timeval *tv)
{
	struct utimbuf ut;

	if (tv != NULL)
	{
		ut.actime= tv[0].tv_sec;
		ut.modtime= tv[1].tv_sec;
		return utime(name, &ut);
	}
	else
		return utime(name, NULL);
}

/*
 * $PchId: utimes.c,v 1.1 1995/11/20 19:52:38 philip Exp $
 */
