/* The <sys/types.h> header contains important data type definitions.
 * It is considered good programming practice to use these definitions, 
 * instead of the underlying base type.  By convention, all type names end 
 * with _t.
 */

#ifndef _SYS__TYPES_H
#define _SYS__TYPES_H

#include <minix/types.h>

/* The type size_t holds all results of the sizeof operator.  At first glance,
 * it seems obvious that it should be an unsigned int, but this is not always 
 * the case. For example, MINIX-ST (68000) has 32-bit pointers and 16-bit
 * integers. When one asks for the size of a 70K struct or array, the result 
 * requires 17 bits to express, so size_t must be a long type.  The type 
 * ssize_t is the signed version of size_t.
 */
#ifndef _SIZE_T
#define _SIZE_T
typedef _mnx_size_t size_t;
#endif

#ifndef _SSIZE_T
#define _SSIZE_T
typedef _mnx_ssize_t ssize_t;
#endif

#ifndef _TIME_T
#define _TIME_T
typedef _mnx_time_t time_t;	   /* time in sec since 1 Jan 1970 0000 GMT */
#endif

#ifndef _CLOCK_T
#define _CLOCK_T
typedef _mnx_clock_t clock_t;	   /* unit for system accounting */
#endif

#ifndef _SIGSET_T
#define _SIGSET_T
typedef _mnx_sigset_t sigset_t;
#endif

typedef _mnx_sighandler_t sighandler_t;

/* Types used in disk, inode, etc. data structures. */
typedef _mnx_dev_t     dev_t;	   /* holds (major|minor) device pair */
typedef _mnx_gid_t     gid_t;	   /* group id */
typedef _mnx_ino_t     ino_t; 	   /* i-node number */
typedef _mnx_mode_t   mode_t;	   /* file type and permissions bits */
typedef _mnx_nlink_t nlink_t;	   /* number of links to a file */
typedef _mnx_off_t     off_t;	   /* offset within a file */
typedef _mnx_pid_t     pid_t;	   /* process id (must be signed) */
typedef _mnx_uid_t     uid_t;	   /* user id */
typedef _mnx_block_t block_t;	   /* block number */
typedef _mnx_bit_t     bit_t;	   /* bit number in a bit map */
typedef _mnx_zone1_t zone1_t;	   /* zone number for V1 file systems */
typedef _mnx_zone2_t zone2_t;	   /* zone number for V2 file systems */
typedef _mnx_bitchunk_t bitchunk_t; /* collection of bits in a bitmap */
typedef _mnx_ioreq_t ioreq_t;	   /* ioctl request code */

typedef _mnx_u8_t       u8_t;	   /* 8 bit type */
typedef _mnx_u16_t     u16_t;	   /* 16 bit type */
typedef _mnx_u32_t     u32_t;	   /* 32 bit type */

typedef _mnx_i8_t	i8_t;	/* 9 bit signed type */
typedef _mnx_i16_t	i16_t;	/* 16 bit signed type */
typedef _mnx_i32_t	i32_t;	/* 32 bit signed type */

/* The following types are needed because MINIX uses K&R style function
 * definitions (for maximum portability).  When a short, such as dev_t, is
 * passed to a function with a K&R definition, the compiler automatically
 * promotes it to an int.  The prototype must contain an int as the parameter,
 * not a short, because an int is what an old-style function definition
 * expects.  Thus using dev_t in a prototype would be incorrect.  It would be
 * sufficient to just use int instead of dev_t in the prototypes, but Dev_t
 * is clearer.
 */

typedef _mnx_Bitchunk_t Bitchunk_t;
typedef _mnx_Dev_t           Dev_t;
typedef _mnx_Gid_t           Gid_t;
typedef _mnx_Ino_t           Ino_t;
typedef _mnx_Mode_t         Mode_t;
typedef _mnx_Nlink_t       Nlink_t;
typedef _mnx_U8_t             U8_t;
typedef _mnx_U16_t           U16_t;
typedef _mnx_U32_t           U32_t;
typedef _mnx_Uid_t           Uid_t;
typedef _mnx_Zone1_t       Zone1_t;

#endif /* _SYS__TYPES_H */

/*
 * $PchId: types.h,v 1.4 1995/11/17 22:01:45 philip Exp $
 */
