/*
sys/svrctl.h

Created:	Feb 15, 1994 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef _SYS__SVRCTL_H
#define _SYS__SVRCTL_H

#include <minix/ansi.h>
#include <minix/types.h>
#include <minix/cfg_lib.h>

/* Server control commands have the same encoding as the commands for
 * ioctls.
 */
#include <sys/ioctl.h>
_C_BEGIN

/* MM controls. */

#define MMGEXECCACHE	_IOR('M',  1, struct mmexeccache)
#define MMSEXECCACHE	_IOW('M',  2, struct mmexeccache)
#define MMQUERYPARAM	_IOW('M',  3, struct svrqueryparam)
#define MMSIGNON	_IO ('M',  4)

/* FS controls. */
#define FSQUERYPARAM	_IOW('F',  1, struct svrqueryparam)
#define FSSIGNON	_IOW('F',  2, struct fssignon)
#define FSGPIPEFS	_IOR('F',  3, struct fsdevmap)
#define FSSPIPEFS	_IOR('F',  4, struct fsdevmap)
#define FSDEVMAP	_IORW('F', 5, struct fsdevmap)

/* kernel controls. */
#define SYSQUERYPARAM	_IOW('S',  1, struct svrqueryparam)
#define SYSSIGNON	_IOR('S',  2, struct systaskinfo)
#define SYSREQIRQ	_IOW('S',  3, struct sysreqirq)
#define SYSIOPRIV	_IO ('S',  4)

struct mmexeccache
{
	unsigned long	mec_limit;
	unsigned long	mec_usage;
};

struct svrqueryparam {
	char		*param;		/* Names of parameters to query. */
	_mnx_size_t	psize;		/* Length of param[]. */
	char		*value;		/* To return values. */
	_mnx_size_t	vsize;
};

enum fsdevstyle { STYLE_DEV, STYLE_NDEV, STYLE_TTY, STYLE_CLONE };

struct fssignon {
	_mnx_dev_t	dev;		/* Example device to manage. */
	enum fsdevstyle	style;		/* Management style. */
};

struct fspipefs {
	_mnx_dev_t	dev;		/* Device for pipes. */
};

struct fsdevmap {
	_mnx_dev_t	dev;		/* Input: Device to map. */
	int		task_nr;	/* Output: Task that controls device. */
	int		minor;		/* Output: Minor number of device. */
};

struct systaskinfo {
	int		proc_nr;	/* Process number of caller. */
};

#if _INTEL_CPU
struct sysreqirq {
	int		irq;		/* IRQ requested. */
};
#endif /* _INTEL_CPU */

_PROTOTYPE( int svrctl, (_mnx_ioreq_t _request, void *_data)			);

_C_END
#endif /* _SYS__SVRCTL_H */

/*
 * $PchId: svrctl.h,v 1.6 1995/11/17 21:46:16 philip Exp $
 */
