/* The <sys/stat.h> header defines a struct that is used in the stat() and
 * fstat functions.  The information in this struct comes from the i-node of
 * some file.  These calls are the only approved way to inspect i-nodes.
 */

#ifndef _SYS__STAT_H
#define _SYS__STAT_H

#include <minix/ansi.h>
#include <minix/posix.h>
#include <minix/types.h>

/* Include <minix/cfg_lib.h> to find out if we have symbolic links or not. */
#include <minix/cfg_lib.h>
_C_BEGIN

struct stat {
  _mnx_dev_t st_dev;		/* major/minor device number */
  _mnx_ino_t st_ino;		/* i-node number */
  _mnx_mode_t st_mode;		/* file mode, protection bits, etc. */
  _mnx_nlink_t st_nlink;	/* # links */
  _mnx_uid_t st_uid;		/* uid of the file's owner */
  _mnx_gid_t st_gid;		/* gid of the file's owner */
  _mnx_dev_t st_rdev;
  _mnx_off_t st_size;		/* file size */
  _mnx_time_t st_atime;		/* time of last access */
  _mnx_time_t st_mtime;		/* time of last data modification */
  _mnx_time_t st_ctime;		/* time of last file status change */
};

/* Traditional mask definitions for st_mode. */
#define S_IFMT  0170000		/* type of file */
#define S_IFREG 0100000		/* regular */
#define S_IFBLK 0060000		/* block special */
#define S_IFDIR 0040000  	/* directory */
#define S_IFCHR 0020000		/* character special */
#define S_IFIFO 0010000		/* this is a FIFO */
#define S_ISUID 0004000		/* set user id on execution */
#define S_ISGID 0002000		/* set group id on execution */
				/* next is reserved for future use */
#define S_ISVTX   01000		/* save swapped text even after use */

/* POSIX masks for st_mode. */
#define S_IRWXU   00700		/* owner:  rwx------ */
#define S_IRUSR   00400		/* owner:  r-------- */
#define S_IWUSR   00200		/* owner:  -w------- */
#define S_IXUSR   00100		/* owner:  --x------ */

#define S_IRWXG   00070		/* group:  ---rwx--- */
#define S_IRGRP   00040		/* group:  ---r----- */
#define S_IWGRP   00020		/* group:  ----w---- */
#define S_IXGRP   00010		/* group:  -----x--- */

#define S_IRWXO   00007		/* others: ------rwx */
#define S_IROTH   00004		/* others: ------r-- */ 
#define S_IWOTH   00002		/* others: -------w- */
#define S_IXOTH   00001		/* others: --------x */

/* The following macros test st_mode (from POSIX Sec. 5.6.1.1). */
#define S_ISREG(m)	(((m) & S_IFMT) == S_IFREG)	/* is a reg file */
#define S_ISDIR(m)	(((m) & S_IFMT) == S_IFDIR)	/* is a directory */
#define S_ISCHR(m)	(((m) & S_IFMT) == S_IFCHR)	/* is a char spec */
#define S_ISBLK(m)	(((m) & S_IFMT) == S_IFBLK)	/* is a block spec */
#define S_ISFIFO(m)	(((m) & S_IFMT) == S_IFIFO)	/* is a pipe/FIFO */


/* Function Prototypes. */
_PROTOTYPE( int chmod, (const char *_path, _mnx_Mode_t _mode)		);
_PROTOTYPE( int fstat, (int _fildes, struct stat *_buf)			);
_PROTOTYPE( int mkdir, (const char *_path, _mnx_Mode_t _mode)		);
_PROTOTYPE( int mkfifo, (const char *_path, _mnx_Mode_t _mode)		);
_PROTOTYPE( int stat, (const char *_path, struct stat *_buf)		);
_PROTOTYPE( _mnx_mode_t umask, (_mnx_Mode_t _cmask)			);

#ifdef _MINIX_SOURCE

#if _VMDEXT_SYMLINK
#define S_IFLNK ((_mnx_mode_t) 0120000)	/* symbolic link */
#define S_ISLNK(m)	(((m) & S_IFMT) == S_IFLNK)	/* is a sym link */

_PROTOTYPE( int lstat, (const char *_path, struct stat *_buf)		);
#endif /* _VMDEXT_SYMLINK */

#ifdef _VMDEXT_HIDDENDIRS

/* What follows are definitions for the so-called hidden directories.
 * Hidden directories have the set-uid bit on with the rest of the mode
 * bits indicating the type of hiding using the sys/utsname.h strings.
 * If /usr/bin is hidden with mode 4000, then any reference to it is
 * translated to /usr/bin/i386 if utsname.arch equals i386.  The path
 * /usr/bin@ needs to be used to reference the hidden directory itself.
 */

#define S_HIDDEN  S_ISUID	/* Setting this bit hides a directory */
#define S_ISHIDDEN(m)	(((m) & (S_IFMT|S_HIDDEN)) == (S_IFDIR|S_HIDDEN))

#define S_HTYPE	     0777	/* protection bits are used for the type of
				 * hiding, the protection is fixed to rwxr-xr-x
				 */
#endif /* _VMDEXT_HIDDENDIRS */
#endif /* _MINIX_SOURCE */

_C_END
#endif /* _STAT_H */

/*
 * $PchId: stat.h,v 1.4 1995/11/17 21:48:46 philip Exp $
 */
