/*
sys/nbio.h

Created:	11 April, 1994 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef _SYS__NBIO_H
#define _SYS__NBIO_H

#include <minix/ansi.h>
#include <minix/types.h>
#include <limits.h>
_C_BEGIN

struct timeval;

typedef union nbio_ref
{
	int ref_int;
	void *ref_ptr;
} nbio_ref_t;

#define _nbio_howmany(x, y)   (((x)+((y)-1))/(y))

#define FD_SETSIZE      256
#define NFDBITS (sizeof(fd_mask_t) * CHAR_BIT)      /* bits per mask */

typedef _mnx_u32_t fd_mask_t;
typedef struct fd_set
{
        fd_mask_t fds_bits[_nbio_howmany(FD_SETSIZE, NFDBITS)];
} fd_set_t;

typedef void (*nbio_cb_func_t) _ARGS(( nbio_ref_t _ref, int _res, int _err ));

int nbio_select _ARGS(( int _nfds, _mnx_u32_t *_readfds, _mnx_u32_t *_writefds,
			_mnx_u32_t *_exceptfds, struct timeval *_timeout ));
_mnx_ssize_t nbio_read _ARGS(( int _fd, void *_buf, _mnx_size_t _n ));
_mnx_ssize_t nbio_write _ARGS(( int _fd, void *_buf, _mnx_size_t _n ));

void nbio_register _ARGS(( int _fd ));
void nbio_unregister _ARGS(( int _fd ));
void nbio_setcallback _ARGS(( int _fd, int _op,
				nbio_cb_func_t _func, nbio_ref_t _ref ));
void nbio_inprogress _ARGS(( int _fd, int _op, int _bl_read, int _bl_write,
	int _bl_except ));
int nbio_isinprogress _ARGS(( int _fd, int _op ));
void nbio_completed _ARGS(( int _fd, int _op ));

_C_END
#endif /* _SYS__NBIO_H */

/* $PchId: nbio.h,v 1.4 1995/11/17 21:51:41 philip Exp $ */
