/*
core.h

This header contains the declarations of the headers of the various cores files.

Created 1991-May-4 by Philip Homburg
*/

#ifndef _SYS__CORE_H
#define _SYS__CORE_H

#define CORE_NAME_SIZE	32

typedef struct core_common
{
	u8_t core_magic[4];
	char core_name[CORE_NAME_SIZE];
	u8_t core_cpu;
	u8_t core_flags;
	u16_t core_len;
} core_common_t;

#define CORE_MAGIC0	0x82
#define CORE_MAGIC1	0x12
#define CORE_MAGIC2	0xc4
#define CORE_MAGIC3	0xc0

#define CORE_CPU_I8086	1	
#define CORE_CPU_I80386	2

typedef struct core_memseg
{
	u32_t core_phys;
	u32_t core_vir;
	u32_t core_len;
} core_memseg_t;

typedef struct core_386regs
{
	u32_t core_eax;
	u32_t core_ebx;
	u32_t core_ecx;
	u32_t core_edx;
	u32_t core_esp;
	u32_t core_ebp;
	u32_t core_esi;
	u32_t core_edi;

	u16_t core_es;
	u16_t core_cs;
	u16_t core_ss;
	u16_t core_ds;
	u16_t core_fs;
	u16_t core_gs;

	u32_t core_eflags;
	u32_t core_eip;
} core_386regs_t;

typedef struct core_386
{
	struct core_common cc;
	struct core_386regs cr;
	struct core_memseg c_text;
	struct core_memseg c_data;
	struct core_memseg c_stack;
} core_386_t;

typedef struct core_86regs
{
	u16_t core_ax;
	u16_t core_bx;
	u16_t core_cx;
	u16_t core_dx;
	u16_t core_sp;
	u16_t core_bp;
	u16_t core_si;
	u16_t core_di;

	u16_t core_es;
	u16_t core_cs;
	u16_t core_ss;
	u16_t core_ds;

	u16_t core_flags;
	u16_t core_ip;
} core_86regs_t;

typedef struct core_86
{
	struct core_common cc;
	struct core_86regs cr;
	struct core_memseg c_text;
	struct core_memseg c_data;
	struct core_memseg c_stack;
} core_86_t;

#endif /* _SYS__CORE_H */

/*
 * $PchId: core.h,v 1.3 1995/11/17 21:57:25 philip Exp $
 */
