/* The <regexp.h> header is used by the (V8-compatible) regexp(3) routines. */

#ifndef _REGEXP_H
#define _REGEXP_H

#include <minix/ansi.h>
_C_BEGIN

#define CHARBITS 0377
#define NSUBEXP  10
typedef struct regexp {
	const char *startp[NSUBEXP];
	const char *endp[NSUBEXP];
	char regstart;		/* Internal use only. */
	char reganch;		/* Internal use only. */
	char *regmust;		/* Internal use only. */
	int regmlen;		/* Internal use only. */
	char program[1];	/* Unwarranted chumminess with compiler. */
} regexp;

/* Function Prototypes. */
_PROTOTYPE( regexp *regcomp, (const char *_exp)				);
_PROTOTYPE( int regexec, (regexp *_prog, const char *_string,
							int _bolflag)	);
_PROTOTYPE( void regsub, (regexp *_prog, char *_source, char *_dest)	);
_PROTOTYPE( void regerror, (const char *_message) 			);

_C_END
#endif /* _REGEXP_H */

/*
 * $PchId: regexp.h,v 1.3 1995/11/17 22:11:52 philip Exp $
 */
