/*
minix/posix.h

This include file defines the right feature test macros for POSIX functions.
It started out simple: __STDC__ defined the new ANSI-C compiler so you could
use prototypes. Fortunately this macro was defined by the compiler so you
didn't have to change your makefiles. Then came POSIX 1003.1 with 
_POSIX_SOURCE: POSIX additions to header files defined by ANSI should only
be visible when _POSIX_SOURCE was defined before the header was included.
This required either changes to the source file (define _POSIX_SOURCE at the 
top), or to the makefile (pass the -D_POSIX_SOURCE option to the compiler).

The POSIX 1003.2 made this even worse by requiring _POSIX2_SOURCE for their
extensions (like getopt, popen). This was in draft 9. Later in draft 11.2
they had a new scheme based on _POSIX_C_SOURCE. A value of 1 in _POSIX_C_SOURCE
should be equivalent to _POSIX_SOURCE, and a value of 2 in _POSIX_C_SOURCE
means _POSIX_SOURCE (if supported by the system) and the former _POSIX2_SOURCE.
Other values were not defined, but future changed were expected.

So I created this header file, which should be included at the top of every
POSIX related header. It should define and redefine and macros required by
POSIX standards.

This include file is based on section B.1.1 of the POSIX 1003.2 draft 11.2.
If you have access to a newer draft or a final version, please modify this
comment and the contents of the header files to reflect any changes in the
newer document.

Created:	Aug 13, 1992 by Philip Homburg
*/

#ifndef _MINIX__POSIX_H
#define _MINIX__POSIX_H

#ifdef _MINIX
/* If _MINIX is set, then you will want all the POSIX extensions too. */
#ifndef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2
#endif
#ifndef _MINIX_SOURCE
#define _MINIX_SOURCE
#endif
#endif

#if _POSIX_C_SOURCE >= 1
#ifndef _POSIX_SOURCE
#define _POSIX_SOURCE
#endif
#endif /* _POSIX_C_SOURCE >= 1 */

#if _POSIX_C_SOURCE >= 2
#ifndef _POSIX2_SOURCE
#define _POSIX2_SOURCE
#endif
#endif /* _POSIX_C_SOURCE >= 2 */

#endif /* _MINIX__POSIX_H */

/*
 * $PchId: posix.h,v 1.3 1995/11/18 07:14:39 philip Exp $
 */
