/*
minix/cfg_lib.h

This header file defines some macros that describe configurable values of the
current Minix system. <minix/cfg_lib.h> defines macros in the
implementors name space (e.g. with leading underscore), and 
<minix/cfg_public.h> defines the traditional macros of config.h.

The work os defining macros is not done in this header file but in several
others that are included by this header file. These are:
- <minix/cfg_arch.h> for the architecture (Intel/isa, Moterola/Atari, 
  Sparc/Sun4, etc.
- <minix/cfg_intel.h>, <minix/cfg_atari.h>, etc. macros for a specific
  architecture.
- <minix/cfg_common.h> macros that are common to all architectures, including
  some consistency checks.

Created:	Nov 19, 1992 by Philip Homburg
*/

#ifndef _MINIX__CFG_LIB_H
#define _MINIX__CFG_LIB_H

/* Get the right processor/architecture. cfg_arch also looks for the macro
 * _ARCH
 */
#include <minix/cfg_arch.h>

/* Get the right architecture depended macros. */
#if _INTEL_CPU
#include <minix/cfg_intel.h>
#endif
#if _ATARI_ARCH
#include <minix/cfg_atari.h>
#endif
#if _SPARC_CPU
#include <minix/cfg_sparc.h>
#endif
/* Other posibilities are:
 * #if _AMIGA_ARCH
 * #include <minix/cfg_amiga.h>
 * #endif
 * #if _MAC_ARCH
 * #include <minix/cfg_mac.h>
 * #endif
 * #if _UNIX_ARCH
 * #include <minix/cfg_unix.h>
 * #endif
 */

/* Define macros that are common to all architectures, eg. the default 
 * filesystem buffer cache size if no other value is defined.
 */
#include <minix/cfg_common.h>

#endif /* _MINIX__CFG_LIB_H */

/*
 * $PchId: cfg_lib.h,v 1.3 1995/11/18 07:20:52 philip Exp $
 */
