/*
minix/cfg_intel.h

Define macros for machines with an Intel processor. We assume that these 
machines use 8088/8086/80286/80386/80486 or compatible chip and that the 
architecture is compatible with an original IBM-PC (_PC_ARCH) or with an
IBM-AT (_ISA_ARCH).

Created:	Nov 21, 1992 by Philip Homburg
*/

#ifdef _MINIX__CFG_INTEL_H
# error		minix/cfg_intel.h included twice
#endif

#ifdef _MACHDEP_CONFIG
# error		more than one machine depended config included
#endif

#define _MINIX__CFG_INTEL_H
#define _MACHDEP_CONFIG

#if _INTEL_86_CPU
#define _PC_ARCH		   1
#endif

#if _INTEL_286_CPU || _INTEL_386_CPU
#define _ISA_ARCH		   1
#endif

#if _INTEL_86_CPU || _INTEL_286_CPU
#define _WORD_SIZE		   2
#define _PTR_SIZE		   2
#define _CLICK_SIZE		 256
#define _CLICK_SHIFT		   8
#endif

#if _INTEL_386_CPU
#define _WORD_SIZE		   4
#define _PTR_SIZE		   4
#define _CLICK_SIZE		4096
#define _CLICK_SHIFT		  12
#endif

/* Define _BYTEORDER_16 and _BYTEORDER_32. See <minix/cfg_common.h> for the
 * interpretation of these macros.
 */
#define _BYTEORDER_16		0x0201
#define _BYTEORDER_32		0x04030201

#define _SEGMENTED_MEMORY	   1

#ifndef _VMDEXT_CONSOLE
#define _VMDEXT_CONSOLE		   1
#endif

#ifndef _VMDEXT_TCPIP
#define _VMDEXT_TCPIP		   1
#endif

#if _VMDEXT_VIRT_MEM
#ifndef _FS_NR_BUFS
#define	_FS_NR_BUFS		1024
#endif
#ifndef _FS_NR_BUF_HASH
#define	_FS_NR_BUF_HASH		2048
#endif
#ifndef _USTACK_SAFETY_CLICKS
#define _USTACK_SAFETY_CLICKS	   4
#endif
#ifndef _ARG_MAX
#define _ARG_MAX		16384
#endif
#endif /* _VMDEXT_VIRT_MEM */

#ifndef _FS_Z_MAP_SLOTS
#if _WORD_SIZE == 4
#define _FS_Z_MAP_SLOTS		 128	/* # of blocks in the zone bit map */
#endif
#endif /* _FS_Z_MAP_SLOTS */

#ifndef _VMDEXT_TERMIOS
#define _VMDEXT_TERMIOS		   1
#endif

#ifndef _VMDEXT_SERIAL
#define _VMDEXT_SERIAL		   1
#endif

#ifndef _VMDEXT_RAWKBD
#define _VMDEXT_RAWKBD		   1
#endif

#ifndef _KERNEL_RS232_C_INT_HANDLERS
#define _KERNEL_RS232_C_INT_HANDLERS	1
#endif

#ifndef _VMDEXT_PROFILING
#define _VMDEXT_PROFILING		1
#endif

#ifndef _VMDEXT_MAPPED_VGA
#define _VMDEXT_MAPPED_VGA		1
#endif

#ifndef _VMDEXT_RAWKBD
#define _VMDEXT_RAWKBD			1
#endif

#ifndef _KERNEL_IGNORE_NMI
#define _KERNEL_IGNORE_NMI		1
#endif

#ifndef _VMDEXT_SYM_TAB_IN_SIZES
#define _VMDEXT_SYM_TAB_IN_SIZES	1
#endif

#ifndef _VMDEXT_NEW_CORE_FORMAT
#define _VMDEXT_NEW_CORE_FORMAT		1
#endif

#ifndef _KERNEL_CONS_LINEWRAP
#define _KERNEL_CONS_LINEWRAP		1
#endif

#ifndef _VMDEXT_FPU
#define _VMDEXT_FPU			1
#endif

/*
 * $PchId: cfg_intel.h,v 1.4 1995/11/18 07:21:22 philip Exp $
 */
