/*
bsd-include/sys/types.h

Created:	Sept 1994 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef _BSD__SYS__TYPES_H
#define _BSD__SYS__TYPES_H

#include <machine/endian.h>
#include <mnx/sys/types.h>
#include <mnx/sys/nbio.h>

typedef unsigned char u_char;
typedef unsigned short u_short;
typedef unsigned int u_int;
typedef unsigned long u_long;
typedef char *caddr_t;

typedef i16_t int16_t;
typedef i32_t int32_t;
typedef u8_t u_int8_t;
typedef u16_t u_int16_t;
typedef u32_t u_int32_t;

/* No quite right. */
typedef unsigned long	u_quad_t;	/* quads */
typedef long		quad_t;
typedef quad_t *	qaddr_t;

#define NBBY    8               /* number of bits in a byte */

typedef fd_mask_t fd_mask;
typedef struct fd_set fd_set;

#define FD_SET(n, p)    ((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define FD_CLR(n, p)    ((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define FD_ISSET(n, p)  ((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_COPY(f, t)   bcopy(f, t, sizeof(*(f)))
#define FD_ZERO(p)      bzero(p, sizeof(*(p)))

#endif /* _BSD__SYS__TYPES_H */

/*
 * $PchId: types.h,v 1.1 1995/12/22 22:41:17 philip Exp $
 */
