/*
bsd-include/sys/socket.h

Created:	Sept 1994 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef _BSD__SYS__SOCKET_H
#define _BSD__SYS__SOCKET_H

#include <mnx/net/gen/socket.h>

struct sockaddr
{
	u_char	sa_len;			/* total length */
	u_char	sa_family;		/* address family */
	char	sa_data[14];		/* actually longer; address value */
};

int bind _ARGS(( int __s, struct sockaddr *__name, int __namelen ));
_mnx_ssize_t recvfrom _ARGS(( int __s, void *__buf, size_t __len, int __flags,
			struct sockaddr *__from, int *__fromlen ));
_mnx_ssize_t sendto _ARGS(( int __s, const void *__msg, size_t __len,
	int __flags, const struct sockaddr *__to, int __tolen ));

#endif /* _BSD__SYS__SOCKET_H */

/*
 * $PchId: socket.h,v 1.1 1995/12/22 22:41:16 philip Exp $
 */
