/*
bsd-include/stdlib.h

Created:	Sept 1994 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef _BSD__STDLIB_H
#define _BSD__STDLIB_H

#define _MINIX_SOURCE

#include <sys/cdefs.h>
#include <sys/types.h>
#include <mnx/stdlib.h>
#include <mnx/unistd.h>

int __bsd_daemon _ARGS(( int __nochdir, int __noclose ));
int __bsd_setenv _ARGS(( const char *, const char *, int ));
void __bsd_unsetenv _ARGS(( const char * ));

#define setenv __bsd_setenv
#define unsetenv __bsd_unsetenv

void	*alloca __P((size_t));		/* built-in for gcc */

int cgetset _ARGS(( char *__ent ));
char *cgetcap _ARGS(( char *__buf, char *__cap, int type ));
int cgetent _ARGS(( char **__buf, char **__db_array, char *__name ));
int cgetmatch _ARGS(( char *__buf, char *__name ));
int cgetfirst _ARGS(( char **__buf, char **__db_array ));
int cgetclose _ARGS(( void ));
int cgetnext _ARGS(( char **__bp, char **__db_array ));
int cgetstr _ARGS(( char *__buf, char *__cap, char **__str ));
int cgetustr _ARGS(( char *__buf, char *__cap, char **__str ));
int cgetnum _ARGS(( char *__buf, char *__cap, long *__num ));

int getopt __P((int _argc, char * const _argv[], const char *_optstr));
extern char *optarg;
extern int optind, opterr, optopt;

#endif /* _BSD__STDLIB_H */

/*
 * $PchId: stdlib.h,v 1.1 1995/12/22 22:36:42 philip Exp $
 */
