/*
bsd-include/arpa/nameser.h

Created:	March 1995 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef _BSD__ARPA__NAMESER_H
#define _BSD__ARPA__NAMESER_H

#define dns_hdr_t	HEADER
#define dh_ancount	ancount
#define dh_arcount	arcount
#define dh_qdcount	qdcount
#define dh_id		id

#include <mnx/net/gen/nameser.h>

#undef dns_hdr_t
#undef dh_ancount
#undef dh_arcount
#undef dh_qdcount
#undef dh_id

/*
 * Inline versions of get/put short/long.  Pointer is advanced.
 * We also assume that a "u_int16_t" holds 2 "chars"
 * and that a "u_int32_t" holds 4 "chars".
 *
 * These macros demonstrate the property of C whereby it can be
 * portable or it can be elegant but never both.
 */
#define GETSHORT(s, cp) { \
	register u_char *t_cp = (u_char *)(cp); \
	(s) = ((u_int16_t)t_cp[0] << 8) | (u_int16_t)t_cp[1]; \
	(cp) += 2; \
}

#define GETLONG(l, cp) { \
	register u_char *t_cp = (u_char *)(cp); \
	(l) = (((u_int32_t)t_cp[0]) << 24) \
	    | (((u_int32_t)t_cp[1]) << 16) \
	    | (((u_int32_t)t_cp[2]) << 8) \
	    | (((u_int32_t)t_cp[3])); \
	(cp) += 4; \
}

#define PUTSHORT(s, cp) { \
	register u_int16_t t_s = (u_int16_t)(s); \
	register u_char *t_cp = (u_char *)(cp); \
	*t_cp++ = t_s >> 8; \
	*t_cp   = t_s; \
	(cp) += 2; \
}

/*
 * Warning: PUTLONG --no-longer-- destroys its first argument.  if you
 * were depending on this "feature", you will lose.
 */
#define PUTLONG(l, cp) { \
	register u_int32_t t_l = (u_int32_t)(l); \
	register u_char *t_cp = (u_char *)(cp); \
	*t_cp++ = t_l >> 24; \
	*t_cp++ = t_l >> 16; \
	*t_cp++ = t_l >> 8; \
	*t_cp   = t_l; \
	(cp) += 4; \
}


#endif /* _BSD__ARPA__NAMESER_H */

/*
 * $PchId: nameser.h,v 1.1 1995/12/22 22:38:14 philip Exp $
 */
