/* Error codes.  They are negative since a few system calls, such as READ, can
 * either return a positive number indicating success, or an error code.
 */

#define NERROR            34
#define OK                 0
#define ERROR             -1
#define EPERM             -1
#define ENOENT            -2
#define ESRCH             -3
#define EINTR             -4
#define EIO               -5
#define ENXIO             -6
#define E2BIG             -7
#define ENOEXEC           -8
#define EBADF             -9
#define ECHILD           -10
#define EAGAIN           -11
#define ENOMEM           -12
#define EACCES           -13
#define EFAULT           -14
#define ENOTBLK          -15
#define EBUSY            -16
#define EEXIST           -17
#define EXDEV            -18
#define ENODEV           -19
#define ENOTDIR          -20
#define EISDIR           -21
#define EINVAL           -22
#define ENFILE           -23
#define EMFILE           -24
#define ENOTTY           -25
#define ETXTBSY          -26
#define EFBIG            -27
#define ENOSPC           -28
#define ESPIPE           -29
#define EROFS            -30
#define EMLINK           -31
#define EPIPE            -32
#define EDOM             -33
#define ERANGE           -34

#define E_LOCKED        -101
#define E_BAD_CALL      -102
#define E_LONG_STRING   -103
#define EOF             -104	/* End Of File - used by drivers */

/* The following error codes are generated by the kernel itself. */
#define E_BAD_DEST        -1	/* destination address illegal */
#define E_BAD_SRC         -2	/* source address illegal */
#define E_TRY_AGAIN       -3	/* can't send-- tables full */
#define E_OVERRUN         -4	/* interrupt for task that is not waiting */
#define E_BAD_BUF         -5	/* message buf outside caller's addr space */
#define E_TASK            -6	/* can't send to task */
#define E_NO_MESSAGE      -7	/* RECEIVE failed: no message present */
#define E_NO_PERM         -8	/* ordinary users can't send to tasks */
#define E_BAD_FCN         -9	/* only valid fcns are SEND, RECEIVE, BOTH */
#define E_BAD_ADDR       -10	/* bad address given to utility routine */
#define E_BAD_PROC       -11	/* bad proc number given to utility */
