#################################################################
#			    PCCURSES				#
# Makefile to generate scurses.lib, ccurses.lib, mcurses.lib,	#
# lcurses.lib for turbo c.                                      #
#								#
# This makefile will generate subdirectories and call itself	#
# recursively...						#
#                                                               #
# Use the enclosed make rather than turboc make or MSC make     #
#################################################################
# 1.0:	Release:					870515	#
#################################################################

# The following are the directories where your lib and include files
# will be installed

LIBDIR= \usr\lib
INCDIR= \usr\include
CC = tcc
# suppress the Parameter "XXXXXX" is never used warning
CFLAGS = -w-par

# General definitions:

COBJS=	attrib.obj beep.obj boxes.obj charadd.obj \
	chardel.obj charget.obj charins.obj charpick.obj \
	clrtobot.obj clrtoeol.obj endwin.obj initscr.obj \
	linedel.obj lineins.obj longname.obj move.obj \
	mvcursor.obj newwin.obj options.obj overlay.obj \
	prntscan.obj refresh.obj scrreg.obj setterm.obj \
	stradd.obj strget.obj termmisc.obj tabsize.obj \
	unctrl.obj update.obj winclear.obj windel.obj \
	winerase.obj winmove.obj winscrol.obj wintouch.obj

ASMOBJS= cursesio.obj

OBJS= $(COBJS) $(ASMOBJS)

#################################################################
# 'all' is all that can (and usually is) done			#
#################################################################

all: small compact medium large

#################################################################
# The following copies the header files to their proper place	#
#################################################################

headers: $(INCDIR)\curses.h $(INCDIR)\curspriv.h

$(INCDIR)\curses.h: curses.h
	copy curses.h $(INCDIR)\curses.h

$(INCDIR)\curspriv.h: curspriv.h
	copy curspriv.h $(INCDIR)\curspriv.h

#################################################################
# The following will create a subdirectory for each memory	#
# model, and initiate the make:ing in each one.			#
#################################################################

#################################################################
# create work directory if non-existent, go to it, and		#
# perform the job - small model					#
#################################################################

small:	headers \
	smodel \
	smodel\farnear.inc \
	smodel\smalhuge.inc
	cd smodel
	-make -f ..\makefile $(MAKEFLAGS) "MODEL=s" $(LIBDIR)\scurses.lib
	cd ..

smodel:
	mkdir smodel

smodel\farnear.inc: nearcall.inc
	copy nearcall.inc smodel\farnear.inc

smodel\smalhuge.inc: smaldata.inc
	copy smaldata.inc smodel\smalhuge.inc

#################################################################
# create work directory if non-existent, go to it, and		#
# perform the job - compact model				#
#################################################################

compact: headers \
	cmodel \
	cmodel\farnear.inc \
	cmodel\smalhuge.inc
	cd cmodel
	-make -f ..\makefile $(MAKEFLAGS) "MODEL=c" $(LIBDIR)\ccurses.lib
	cd ..

cmodel:
	mkdir cmodel

cmodel\farnear.inc: nearcall.inc
	copy nearcall.inc cmodel\farnear.inc

cmodel\smalhuge.inc: hugedata.inc
	copy hugedata.inc cmodel\smalhuge.inc

#################################################################
# create work directory if non-existent, go to it, and		#
# perform the job - medium model				#
#################################################################

medium: headers \
	mmodel \
	mmodel\farnear.inc	\
	mmodel\smalhuge.inc
	cd mmodel
	-make -f ..\makefile $(MAKEFLAGS) "MODEL=m" $(LIBDIR)\mcurses.lib
	cd ..

mmodel:
	mkdir mmodel

mmodel\farnear.inc: farcall.inc
	copy farcall.inc mmodel\farnear.inc

mmodel\smalhuge.inc: smaldata.inc
	copy smaldata.inc mmodel\smalhuge.inc

#################################################################
# create work directory if non-existent, go to it, and		#
# perform the job - large model					#
#################################################################

large: headers \
	lmodel \
	lmodel\farnear.inc	\
	lmodel\smalhuge.inc
	cd lmodel
	-make -f ..\makefile $(MAKEFLAGS) "MODEL=l" $(LIBDIR)\lcurses.lib
	cd ..

lmodel:
	mkdir lmodel

lmodel\farnear.inc: farcall.inc
	copy farcall.inc lmodel\farnear.inc

lmodel\smalhuge.inc: hugedata.inc
	copy hugedata.inc lmodel\smalhuge.inc

#################################################################
# Put together the library in file tmp.lib, then copy it to	#
# the appropriate name for the memory model in question, and	#
# delete the temporary file					#
#################################################################

$(LIBDIR)\$(MODEL)curses.lib: $(OBJS)
	del tmp.lib
	lib @..\curses.cmd
	copy tmp.lib $(LIBDIR)\$(MODEL)curses.lib
	del tmp.lib

#################################################################
# commands and dependencies for individual modules		#
#################################################################

attrib.obj: ..\attrib.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -oattrib ..\attrib.c

beep.obj: ..\beep.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -obeep ..\beep.c

boxes.obj: ..\boxes.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -oboxes ..\boxes.c

charadd.obj: ..\charadd.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -ocharadd ..\charadd.c

chardel.obj: ..\chardel.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -ochardel ..\chardel.c

charget.obj: ..\charget.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -ocharget ..\charget.c

charins.obj: ..\charins.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -ocharins ..\charins.c

charpick.obj: ..\charpick.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -ocharpick ..\charpick.c

clrtobot.obj: ..\clrtobot.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -oclrtobot ..\clrtobot.c

clrtoeol.obj: ..\clrtoeol.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -oclrtoeol ..\clrtoeol.c

endwin.obj: ..\endwin.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -oendwin ..\endwin.c

initscr.obj: ..\initscr.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -oinitscr ..\initscr.c

linedel.obj: ..\linedel.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -olinedel ..\linedel.c

lineins.obj: ..\lineins.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -olineins ..\lineins.c

longname.obj: ..\longname.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -olongname ..\longname.c

move.obj: ..\move.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -omove ..\move.c

mvcursor.obj: ..\mvcursor.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -omvcursor ..\mvcursor.c

newwin.obj: ..\newwin.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -onewwin ..\newwin.c

options.obj: ..\options.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -ooptions ..\options.c

overlay.obj: ..\overlay.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -ooverlay ..\overlay.c

prntscan.obj: ..\prntscan.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -oprntscan ..\prntscan.c

refresh.obj: ..\refresh.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -orefresh ..\refresh.c

scrreg.obj: ..\scrreg.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -oscrreg ..\scrreg.c

setterm.obj: ..\setterm.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -osetterm ..\setterm.c

stradd.obj: ..\stradd.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -ostradd ..\stradd.c

strget.obj: ..\strget.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -ostrget ..\strget.c

tabsize.obj: ..\tabsize.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -otabsize ..\tabsize.c

termmisc.obj: ..\termmisc.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -otermmisc ..\termmisc.c

unctrl.obj: ..\unctrl.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -ounctrl ..\unctrl.c

update.obj: ..\update.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -oupdate ..\update.c

winclear.obj: ..\winclear.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -owinclear ..\winclear.c

windel.obj: ..\windel.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -owindel ..\windel.c

winerase.obj: ..\winerase.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -owinerase ..\winerase.c

winmove.obj: ..\winmove.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -owinmove ..\winmove.c

winscrol.obj: ..\winscrol.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -owinscrol ..\winscrol.c

wintouch.obj: ..\wintouch.c ..\curses.h ..\curspriv.h
	$(CC) $(CFLAGS) -m$(MODEL) -c -O -owintouch ..\wintouch.c

cursesio.obj: ..\cursesio.asm
	masm ..\cursesio.asm/mx,cursesio.obj,nul,nul;

#################################################################
# Perform a backup of the files in the directory where the	#
# 'make backup' command was issued - copies all files to the	#
# directory \pcurses on the A: floppy				#
#################################################################

backup:
	@echo ***** backup of curses *****
	@echo Insert backup diskette in drive A: and hit any key!
	@pause
	mkdir a:\pcurses
	del a:\pcurses\*.*
	copy *.* a:\pcurses

#################################################################
# Remove all temporary files and work directories that were	#
# created							#
#################################################################

clean:
	del smodel\*.*
	del cmodel\*.*
	del mmodel\*.*
	del lmodel\*.*
	rmdir smodel
	rmdir cmodel
	rmdir mmodel
	rmdir lmodel
