/****************************************************************/
/* Addch() routines of the PCcurses package			*/
/*								*/
/****************************************************************/
/* This version of curses is based on ncurses, a curses version	*/
/* originally written by Pavel Curtis at Cornell University.	*/
/* I have made substantial changes to make it run on IBM PC's,	*/
/* and therefore consider myself free to make it public domain.	*/
/*		Bjorn Larsson (...mcvax!enea!infovax!bl)	*/
/****************************************************************/
/* 1.0:	Release:					870515	*/
/****************************************************************/
/* Modified to run under the MINIX operating system by Don Cope */
/* These changes are also released into the public domain.      */
/* 							900906  */
/****************************************************************/

#include <curses.h>
#include "curspriv.h"

/****************************************************************/
/* Newline() does line advance and returns the new cursor line.	*/
/* If error, return -1.						*/
/****************************************************************/

static	short	newline(win, lin)
  WINDOW	*win;
  short 	 lin;
  {
  if (++lin > win->_regbottom)
    {
    lin--;
    if (win->_scroll)
      scroll(win);
    else
      return(-1);
    } /* if */
  return(lin);
  } /* newline */

/****************************************************************/
/* Waddch() inserts character 'c' at the current cursor posi-	*/
/* tion in window 'win', and takes any actions as dictated by	*/
/* the character.						*/
/****************************************************************/

int waddch(win, c)
  register WINDOW	*win;
  char			 c;
  {
  short	x = win->_curx;
  short	y = win->_cury;
  short	newx;
  int	ch = c;
  int  	ts = win->_tabsize;

  ch &= 0xff;			/* kill any sing-extend */
  if (y > win->_maxy  ||  x > win->_maxx  ||  y < 0  ||  x < 0)
    return(ERR);
  switch (ch)
    {
    case '\t':	for (newx = ((x/ts) + 1) * ts; x < newx; x++)
		  {
		  if (waddch(win, ' ') == ERR)
		    return(ERR);
		  if (win->_curx == 0)		/* if tab to next line */
		    return(OK);			/* exit the loop */
		  } /* for */
		return(OK);
    case '\n':	if (_cursvar.autocr && !(_cursvar.raw)) /* if lf -> crlf */
		  x = 0;
		if ((y = newline(win, y)) < 0)
		  return(ERR);
		break;
    case '\r':	x = 0;
		break;
    case '\b':
		if (--x < 0)	/* no back over left margin */
		  		x = 0;
		if (win->_minchng[y] == _NO_CHANGE)
		{
		  	win->_minchng[y] = x-1;
			win->_maxchng[y] = x+1;
		}
		else
		    if (x < win->_minchng[y])
			    win->_minchng[y] = x-1;
		    else
		    	if (x > win->_maxchng[y])
					win->_maxchng[y] = x+1;
		break;
    case 0x7f:	if (waddch(win,'^') == ERR)
		  return(ERR);
		return(waddch(win,'?'));
    default:	if (ch < ' ')			/* handle control chars */
		  {
		  if (waddch(win,'^') == ERR)
		    return(ERR);
		  return(waddch(win,c + '@'));
		  } /* if */
		ch |= (win->_attrs & ATR_MSK);
		if (win->_line[y][x] != ch)	/* only if data change */
		  {
		  if (win->_minchng[y] == _NO_CHANGE)
		    win->_minchng[y] = win->_maxchng[y] = x;
		  else
		    if (x < win->_minchng[y])
		      win->_minchng[y] = x-1;
		    else
		      if (x > win->_maxchng[y])
			win->_maxchng[y] = x+1;
		  } /* if */
		win->_line[y][x++] = ch;
		if (x > win->_maxx)		/* wrap around test */
		  {
		  x = 0;
		  if ((y = newline(win, y)) < 0)
		    return(ERR);
		  } /* if */
		break;
    } /* switch */
  win->_curx = x;
  win->_cury = y;
  return(OK);
  } /* waddch */

/****************************************************************/
/* Addch() inserts character 'c' at the current cursor posi-	*/
/* tion in stdscr, and takes any actions as dictated by the	*/
/* character.							*/
/****************************************************************/

int addch(c)
  char	 c;
  {
  return (waddch(stdscr,c));
  } /* addch */

/****************************************************************/
/* Mvaddch() moves to position in stdscr, then inserts charac-	*/
/* ter 'c' at that point, and takes any actions as dictated by	*/
/* the character.						*/
/****************************************************************/

int mvaddch(y,x,c)
  int	 x;
  int	 y;
  char	 c;
  {
  if (wmove(stdscr,y,x) == ERR)
    return(ERR);
  return (waddch(stdscr,c));
  } /* mvaddch */

/****************************************************************/
/* Mvwaddch() moves to position in window 'win', then inserts	*/
/* character 'c' at that point in the window, and takes any	*/
/* actions as dictated by the character.			*/
/****************************************************************/

int mvwaddch(win,y,x,c)
  WINDOW *win;
  int	  x;
  int	  y;
                                                                                                           