/****************************************************************/
/* Box() routines of the PCcurses package			*/
/*								*/
/****************************************************************/
/* This version of curses is based on ncurses, a curses version	*/
/* originally written by Pavel Curtis at Cornell University.	*/
/* I have made substantial changes to make it run on IBM PC's,	*/
/* and therefore consider myself free to make it public domain.	*/
/*		Bjorn Larsson (...mcvax!enea!infovax!bl)	*/
/****************************************************************/
/* 1.0:	Release:					870515	*/
/****************************************************************/
/* Modified to run under the MINIX operating system by Don Cope */
/* These changes are also released into the public domain.      */
/* 							900906  */
/****************************************************************/

#include <curses.h>
#include "curspriv.h"

/****************************************************************/
/* wbox(win,ymin,xmin,ymax,xmax,v,h) draws a box in window	*/
/* 'win', enclosing the area xmin-xmax and ymin-xmax. If	*/
/* xmax and/or ymax is 0, the window max value is used. 'v' and	*/
/* 'h' are the vertical and horizontal characters to use. If	*/
/* 'v' and 'h' are 0, wbox will use the alternate character set */
/* in a pretty way.						*/
/****************************************************************/

int	wbox(win,ymin,xmin,ymax,xmax,v,h)
WINDOW	*win;
int		 ymin;
int		 xmin;
int		 ymax;
int		 xmax;
int		 v;
int		 h;
{
  int	 vc,hc,ulc,urc,llc,lrc;	/* corner chars */
  int	 i,oldattrs;

  oldattrs = win->_attrs;
  if (ymax == 0)
  ymax = win->_maxy;
  if (xmax == 0)
  xmax = win->_maxx;

  if (ymin >= win->_maxy || ymax > win->_maxy ||
  xmin >= win->_maxx || xmax > win->_maxx ||
  ymin >= ymax || xmin >= xmax)
  return(ERR);

  vc = v;
  hc = h;
  ulc = urc = llc = lrc = vc;		/* default same as vertical */

  if (v==0 && h==0)
  {
    ulc = ACS_ULCORNER;
    urc = ACS_URCORNER;
    llc = ACS_LLCORNER;
    lrc = ACS_LRCORNER;
    hc = ACS_HLINE;
    vc = ACS_VLINE;
    win->_attrs |= A_ALTCHARSET;
  }
  
  for (i = xmin+1;i <= xmax-1;i++)
  {
    win->_line[ymin][i] = hc | win->_attrs;
    win->_line[ymax][i] = hc | win->_attrs;
  }
  for (i = ymin+1;i <= ymax-1;i++)
  {
    win->_line[i][xmin] = vc | win->_attrs;
    win->_line[i][xmax] = vc | win->_attrs;
  }
  win->_line[ymin][xmin] = ulc | win->_attrs;
  win->_line[ymin][xmax] = urc | win->_attrs;
  win->_line[ymax][xmin] = llc | win->_attrs;
  win->_line[ymax][xmax] = lrc | win->_attrs;

  for (i=ymin; i <= ymax ; i++)
  {
    if (win->_minchng[i] == _NO_CHANGE)
    {
      win->_minchng[i] = xmin;
      win->_maxchng[i] = xmax;
    } /* if */
    else
    {
      win->_minchng[i] = min(win->_minchng[i], xmin);
      win->_maxchng[i] = max(win->_maxchng[i], xmax);
    } /* else */
  } /* for */
  win->_attrs=oldattrs;
  return(OK);
} /* box */

/****************************************************************/
/* box(win,v,h) draws a box around window window 'win'. 'v' and	*/
/* 'h' are the vertical and horizontal characters to use.	*/
/****************************************************************/

void	box(win,vc,hc)
WINDOW	*win;
int		 vc;
int		 hc;
{
  wbox(win,0,0,0,0,vc,hc);
} /* box */
