/*
 *		c o n f i g . h
 *
 *	This file is used to control which options are generated
 *	when you build the compiler.   Set the options below to
 *	match your particular system.
 *
 *	You must select options from either the 68000 OR the INTEL 386
 *	sections - not both .   All options from the section you do not
 *	want should be left unset.
 */
/*
 *	GENERAL OPTIONS
 *	~~~~~~~~~~~~~~~
 */
/*
 *	Set the following options to suit your system/requirements
 */
#define	WARNLEVEL_DEFAULT 3 /* default warning level */
/* #define HAS_NLS 1	/* system supports message catalogues */
/* #define NOFLOAT 1 	/* Do not generate floating point support */
/* #define NODOUBLE 1	/* Treat 'float' and 'double' as same (MFFP version) */
/*
 *	These options tend not to be changed except when developing
 */
/* #define VERBOSE 1	/* Generate verbose mode code in compiler */
/* #define ICODE   1	/* Generate icode analysis code in compiler */

/*
 *	MOTOROLA 68000 OPTIONS
 *	~~~~~~~~~~~~~~~~~~~~~~
 */
#define MC68000 1	/* This is an 68000 compiler */
/* #define MC68010 1	/* This is an 68010 compiler */
/* #define MC68020 1	/* This is an 68020 compiler */
/* #define MC68030 1	/* This is an 68030 compiler */

#define TARGET_ACK 1	/* Assembler Code is for the ACK assembler */
/* #define TARGET_CPM 1	/* Assembler Code is for the DRI assembler */
/* #define TARGET_GAS 1	/* Assembler Code is for the GAS assembler */

#define MOVEM_BUG 1	/* Assembler (e.g. ACK) has bug in MOVEM handling */

/*
 *	INTEL 386 OPTIONS
 *	~~~~~~~~~~~~~~~~~
 */

/* #define INTEL_386 1	/* This is an Intel 386 compiler */

/* #define FUNCS_USE_387 1	/* ... very special option */

/* #define TARGET_GAS	/* Assembler Syntax is for GAS/Sun386i */
/* #define TARGET_SUN	/* Assembler Syntax is for Sun386i */
/* #define TARGET_BAS	/* Assembler Syntax is for BCC assembler */

/*
 *	Do not change anything beyond this point
 *	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */

#ifdef CPU_DEFINED
#undef CPU_DEFINED
#endif

#ifdef MC68000
#define MC680X0
#ifdef CPU_DEFINED
error, define only one target CPU!
#endif
#define CPU_DEFINED
#endif /* MC68000 */

#ifdef MC68010
#define MC680X0
#ifdef CPU_DEFINED
error, define only one target CPU!
#endif
#define CPU_DEFINED
#endif

#ifdef MC68020
#define MC680X0
#ifdef CPU_DEFINED
error, define only one target CPU!
#endif
#define CPU_DEFINED
#endif

#ifdef MC68030
#define MC680X0
#ifdef CPU_DEFINED
error, define only one target CPU!
#endif
#define CPU_DEFINED
#endif

#ifdef MC68040
#define MC680X0
#ifdef CPU_DEFINED
error, define only one target CPU!
#endif
#define CPU_DEFINED
#endif

#ifdef MC680X0
#define PROGNAME   "c68"
#ifdef QDOS
#define LIST_NAME  "c68_list"
#define ICODE_NAME "c68_icode"
#else
#define LIST_NAME  "c68.list"
#define ICODE_NAME "c68.icode"
#endif
#endif


#ifdef  INTEL_486
#ifndef INTEL_386
#define INTEL_386
#endif
#endif

#ifdef INTEL_386
#ifdef CPU_DEFINED
error, define only one target CPU!
#endif
#define CPU_DEFINED
#define PROGNAME   "c386"
#define LIST_NAME  "c386.list"
#define ICODE_NAME "c386.icode"
/*
 * if FUNCS_USE_387 is defined, extra library calls are generated if the
 * nofpu option is in effect that allows to use code generated by
 * this compiler to be linked with functions that return values
 * on the 387 stack
 */
#define FUNCS_USE_387
#endif

#ifndef CPU_DEFINED
error, target CPU type must be defined
#endif

#define _CONFIG_H

