#include	<stdio.h>
#include	"c.h"
#include	"expr.h"
#include	"gen.h"
#include	"cglbdec.h"

/*
 * 68000 C compiler
 *
 * Copyright 1984, 1985, 1986 Matthew Brandt. all commercial rights reserved.
 *
 * This compiler is intended as an instructive tool for personal use. Any use
 * for profit without the written consent of the author is prohibited.
 *
 * This compiler may be distributed freely for non-commercial use as long as
 * this notice stays intact. Please forward any enhancements or questions to:
 *
 * Matthew Brandt Box 920337 Norcross, Ga 30092
 *
 * This compiler has been enhanced and corrected at the end of 1989 by Christoph
 * van Wullen, who generated this version. Look at the file README.CVW for
 * further comments.
 */

struct kwblk {
    char	   *word;
    enum e_sym	    stype;
}		keywords[] = {

    {
	"int", kw_int
    }, {
	"char", kw_char
    }, {
	"long", kw_long
    },
    {
	"float", kw_float
    }, {
	"double", kw_double
    }, {
	"return", kw_return
    },
    {
	"struct", kw_struct
    }, {
	"union", kw_union
    }, {
	"typedef", kw_typedef
    },
    {
	"enum", kw_enum
    }, {
	"static", kw_static
    }, {
	"auto", kw_auto
    },
    {
	"sizeof", kw_sizeof
    }, {
	"do", kw_do
    }, {
	"if", kw_if
    },
    {
	"else", kw_else
    }, {
	"for", kw_for
    }, {
	"switch", kw_switch
    },
    {
	"while", kw_while
    }, {
	"short", kw_short
    }, {
	"extern", kw_extern
    },
    {
	"case", kw_case
    }, {
	"goto", kw_goto
    }, {
	"default", kw_default
    },
    {
	"register", kw_register
    }, {
	"unsigned", kw_unsigned
    },
    {
	"break", kw_break
    }, {
	"continue", kw_continue
    }, {
	"void", kw_void
    },
    {
	0, 0
    }
};

/*
 * cvw: kw_int is never returned. Instead, kw_short or kw_long, depending on
 * short_option, is returned
 *
 * The inline expansion of strcmp in search and searchkw reduced the execution
 * time by over 25 percent.
 */
searchkw()
{
    register char  *s1;
    register char  *s2;
    register struct kwblk *kwbp;
    kwbp = keywords;
    while (kwbp->word != 0) {
	s1 = lastid;
	s2 = kwbp->word;
	kwbp++;
	for (;;) {
	    if (*s1++ != *s2)
		break;
	    if (*s2++ == '\0') {
		lastst = (--kwbp)->stype;
		return;
	    }
	}
    }
}
