/*
 * genffp.c -- generate a MOTOROLA FastFloatingPoint number
 *
 * This compiler has been enhanced and corrected at the end of 1989 by Christoph
 * van Wullen, who generated this version. Look at the file README.CVW for
 * further comments.
 *
 */

/*
 * The following floating-point operations are needed in this module:
 *
 * - comparision with 0.0, 0.5 and 1.0 - division by 2.0 - multiplication with
 * 2.0 (performed as addition here) - subtraction of 1.0
 */

unsigned long
genffp(d)
    double	    d;
{
    unsigned long   mantissa;
    int 	    sign = 0, exponent = 64, i;

    if (d < 0.0) {
	sign = 128;
	d = -d;
    }
    while (d < 0.5) {
	d += d;
	--exponent;
	if (exponent == 0)
	    return sign;	/* zero fp number */
    }

    while (d >= 1.0) {
	d /= 2.0;
	++exponent;
	if (exponent >= 127)
	    return 127 + sign;	/* +/- infinity */
    }

    /* 0.5 <=d <1.0 now: construct the mantissa */

    mantissa = 0;
    for (i = 0; i < 24; i++) {
	/* 24 mantissa bits */
	d += d;
	mantissa = mantissa + mantissa;
	if (d >= 1.0) {
	    ++mantissa;
	    d -= 1.0;
	}
    }

    /* round up, if the next bit would be 1 */
    if (d >= 0.5)
	++mantissa;
    /* check on mantissa overflow */
    if (mantissa > 0xFFFFFF) {
	++exponent;
	/* exponent overflow? */
	if (exponent >= 127)
	    return (127 + sign);
	mantissa >>= 1;
    }
    /* put the parts together and return the value */

    return (mantissa << 8) + sign + exponent;
}
