#include	<stdio.h>
#include	"c.h"
#include	"expr.h"
#include	"gen.h"
#include	"cglbdec.h"

/*
 * 68000 C compiler
 *
 * Copyright 1984, 1985, 1986 Matthew Brandt. all commercial rights reserved.
 *
 * This compiler is intended as an instructive tool for personal use. Any use
 * for profit without the written consent of the author is prohibited.
 *
 * This compiler may be distributed freely for non-commercial use as long as
 * this notice stays intact. Please forward any enhancements or questions to:
 *
 * Matthew Brandt Box 920337 Norcross, Ga 30092
 *
 * This compiler has been enhanced and corrected at the end of 1989 by Christoph
 * van Wullen, who generated this version. Look at the file README.CVW for
 * further comments.
 */

extern TYP	tp_long, tp_short;

/* function compilation routines		 */

funcbody(sp, names, nparms)
/*
 * funcbody starts with the current symbol being the begin for the local
 * block or the first symbol of the parameter declaration
 */
    SYM 	   *sp;
    char	   *names[];
int		nparms;
{
    long	    poffset;
    int i, l_rptr = 0;
    SYM 	   *sp1, *mk_int();
    int old_global;
    regptr = 0;
    old_global = global_flag;
    global_flag = 0;
    poffset = 8;		/* size of return block */
    if (lastst != begin)
	dodecl(sc_member);	/* declare parameters */
    /* undeclared parameters are int's */
    for (i = 0; i < nparms; ++i) {
	if ((sp1 = search(names[i], lsyms.tail)) == 0)
	    sp1 = mk_int(names[i]);
	/*
	 * cvw:
	 *
	 * promote
	 *
	 * char, unsigned char, short, unsigned short, enum ==> int float ==>
	 * double convert x[] to *x by clearing val_flag
	 */
	switch (sp1->tp->type) {
	case bt_char:
	case bt_uchar:
	    if (short_option)
		sp1->tp = &tp_short;
	    else
		sp1->tp = &tp_long;
	    break;
	case bt_short:
	case bt_ushort:
	case bt_enum:
	    if (!short_option)
		sp1->tp = &tp_long;
	    break;
	case bt_float:
	    /* if float != double, promote it */
	    break;
	case bt_pointer:
	    /* arrays promote to pointer */
	    if (sp1->tp->val_flag != 0) {
		TYP	       *tp1 = (TYP *) xalloc((int) sizeof(TYP));
		*tp1 = *(sp1->tp);
		tp1->st_flag = 0;
		sp1->tp = tp1;
		sp1->tp->val_flag = 0;
		sp1->tp->size = 4;
	    }
	    break;
	}
	/* sp1->value.i of undeclared parameters is 0 (mk_int) */
	if (l_rptr < regptr && reglst[l_rptr] == sp1->value.i)
	    /* register attribute set */
	    reglst[l_rptr++] = poffset;

	sp1->value.i = poffset;
	poffset += sp1->tp->size;
	sp1->storage_class = sc_auto;
    }
    if (lastst != begin)
	error(ERR_BLOCK);
    else {
	block(sp);
	funcbottom();
    }
    global_flag = old_global;
}

SYM	       *
mk_int(name)
    char	   *name;
{
    SYM 	   *sp;
    TYP 	   *tp;
    sp = (SYM *) xalloc((int) sizeof(SYM));
    tp = (TYP *) xalloc((int) sizeof(TYP));
    tp->st_flag = 0;
    if (short_option) {
	tp->type = bt_short;
	tp->size = 2;
    } else {
	tp->type = bt_long;
	tp->size = 4;
    }
    tp->btp = 0;
    tp->lst.head = 0;
    tp->sname = 0;
    sp->name = name;
    sp->storage_class = sc_auto;
    sp->value.i = 0;		/* dummy */
    sp->tp = tp;
    append(&sp, &lsyms);
    return sp;
}

check_table(head)
    SYM 	   *head;
{
    while (head != 0) {
	if (head->storage_class == sc_ulabel) {
	    fprintf(stderr,"*** UNDEFINED LABEL - %s\n", head->name);
	    if (list_option)
		fprintf(list, "*** UNDEFINED LABEL - %s\n", head->name);
	}
	head = head->next;
    }
}

funcbottom()
{
    nl();
    check_table(labsyms.head);
    lc_auto = 0;
    max_auto = 0;
    if (list_option && lsyms.head != 0) {
	fprintf(list, "\n\n*** argument symbol table ***\n\n");
	list_table(&lsyms, 0);
	fprintf(list, "\n\n\n");
    }
    if (list_option && labsyms.head != 0) {
	fprintf(list, "\n\n*** label symbol table ***\n\n");
	list_table(&labsyms, 0);
	fprintf(list,"\n\n\n");
    }
    rel_local();		/* release local symbols */
}

block(sp)
    SYM 	   *sp;
{
    fprintf(stderr,"%s\n", sp->name);
#ifdef ICODE
    if (icode_option)
	if (sp->storage_class == sc_external || sp->storage_class == sc_global)
	    fprintf(icode, "%s:\n", sp->name);
	else
	    fprintf(icode, "L%ld:\n", sp->value.i);
#endif
    needpunc(begin);
    genfunc(compound(0));
    cseg();
    dumplits();
    put_align(2);
    if (sp->storage_class == sc_external || sp->storage_class == sc_global)
	g_strlab(sp->name);
    else
	put_label((int)sp->value.i);
    flush_peep();
}
