/*
 * 68000 C compiler
 *
 * Copyright 1984, 1985, 1986 Matthew Brandt. all commercial rights reserved.
 *
 * This compiler is intended as an instructive tool for personal use. Any use
 * for profit without the written consent of the author is prohibited.
 *
 * This compiler may be distributed freely for non-commercial use as long as
 * this notice stays intact. Please forward any enhancements or questions to:
 *
 * Matthew Brandt Box 920337 Norcross, Ga 30092
 *
 * This compiler has been enhanced and corrected at the end of 1989 by Christoph
 * van Wullen, who generated this version. Look at the file README.CVW for
 * further comments.
 */

/* expression tree descriptions	 */

enum e_node {
    en_void,
    en_icon, en_fcon, en_labcon, en_nacon, en_autocon,
    en_fcall, en_tempref, en_add, en_sub, en_mul, en_mod,
    en_div, en_lsh, en_rsh, en_cond, en_assign, en_eq, en_ne,
    en_asadd, en_assub, en_asmul, en_asdiv, en_asmod, en_asrsh,
    en_asxor,
    en_aslsh, en_asand, en_asor, en_uminus, en_not, en_compl,
    en_lt, en_le, en_gt, en_ge, en_and, en_or, en_land, en_lor,
    en_xor, en_ainc, en_adec,
    en_ref, en_cast
};

/* statement node descriptions	 */

enum e_stmt {
    st_expr, st_while, st_for, st_do, st_if, st_switch,
    st_case, st_goto, st_break, st_continue, st_label,
    st_return, st_compound, st_default
};

struct enode {
    enum e_node     nodetype;
    union {
	long		i;
	double		f;
	char	       *sp;
	struct enode   *p[2];
    }		    v;
    enum e_bt	   etype;
    long	   esize;
};

#define NIL_ENODE ( (struct enode *) 0)

struct snode {
    enum e_stmt     stype;
    struct snode   *next;	/* next statement */
    struct enode   *exp;	/* condition or expression */
    struct snode   *s1;		/* internal statement */
    union {
	struct enode *e;	/* condition or expression */
	struct snode *s;	/* internal statement (else) */
	int	i;		/* label or flag */
	} v1,v2;
};

#define NIL_SNODE ( (struct snode *) 0)


struct cse {
    struct cse	   *next;
    struct enode   *exp;	/* optimizable expression */
    int 	    uses;	/* number of uses */
    int 	    duses;	/* number of dereferenced uses */
    int 	    voidf;	/* cannot optimize flag */
    int 	    reg;	/* allocated register */
};

struct enode   *mk_node();
struct enode   *mk_icon();
struct enode   *parmlist();
struct enode   *copynode();
struct snode   *statement();
struct snode   *compound();
