#include	<stdio.h>
#include	"c.h"
#include	"expr.h"
#include	"gen.h"
#include	"cglbdec.h"

/*
 * 68000 C compiler
 *
 * Copyright 1984, 1985, 1986 Matthew Brandt. all commercial rights reserved.
 *
 * This compiler is intended as an instructive tool for personal use. Any use
 * for profit without the written consent of the author is prohibited.
 *
 * This compiler may be distributed freely for non-commercial use as long as
 * this notice stays intact. Please forward any enhancements or questions to:
 *
 * Matthew Brandt Box 920337 Norcross, Ga 30092
 *
 * This compiler has been enhanced and corrected at the end of 1989 by Christoph
 * van Wullen, who generated this version. Look at the file README.CVW for
 * further comments.
 */

TYP	       *head = 0;
TYP	       *tail = 0;
char	       *declid = 0;

extern TYP	tp_econst;

/* variables for function parameter lists */
static int	nparms;
static char    *names[30];	/* 30 parameters maximum */

long
imax(i, j)
    long	    i, j;
{
    return (i > j) ? i : j;
}

char	       *
strsave(s)
    char	   *s;
{
    char	   *p, *q;
    q = p = (char *) xalloc(strlen(s) + 1);
    while (*p++ = *s++);
    return q;
}

TYP	       *
mk_type(bt, siz)
    enum e_bt	    bt;
    int 	    siz;
{
    TYP 	   *tp;
    tp = (TYP *) xalloc((int) sizeof(TYP));
    tp->val_flag = 0;
    tp->size = siz;
    tp->type = bt;
    tp->sname = 0;
    tp->lst.head = 0;
    tp->st_flag = global_flag;
    return tp;
}

int
decl(table)
    TABLE	   *table;
{
    SYM 	   *sp;

    /* 
     * at top level, 'int' is changed to 'short' or 'long'
     */

    if (lastst == kw_int) 
	lastst = short_option ? kw_short : kw_long;

    switch (lastst) {
    case kw_void:
	head = tail = mk_type(bt_void, -1);
	getsym();
	break;
    case kw_char:
	head = tail = mk_type(bt_char, 1);
	getsym();
	break;
    case kw_short:
	head = tail = mk_type(bt_short, 2);
	getsym();
	if (lastst == kw_int)
	    getsym();
	break;
    case kw_long:
	head = tail = mk_type(bt_long, 4);
	getsym();
	if (lastst == kw_int)
	    getsym();
	break;
    case kw_unsigned:
	getsym();
	if (lastst == kw_int)
	    lastst = short_option ? kw_short : kw_long;
	switch (lastst) {
	case kw_long:
	    head = tail = mk_type(bt_ulong, 4);
	    getsym();
	    if (lastst == kw_int)
		getsym();
	    break;
	case kw_char:
	    head = tail = mk_type(bt_uchar, 1);
	    getsym();
	    break;
	case kw_short:
	    head = tail = mk_type(bt_ushort, 2);
	    getsym();
	    if (lastst == kw_int)
		getsym();
	    break;
	default:
	    head = tail = short_option ?
		mk_type(bt_ushort, 2) :
		mk_type(bt_ulong, 4);
	    break;
	}
	break;
    case id:
	if ((sp = gsearch(lastid)) != 0 &&
	    sp->storage_class == sc_typedef)
	    /* type identifier */
	{
	    getsym();
	    head = tail = sp->tp;
	    break;
	}
	/* else fall through */
    case openpa:
    case star:
	/* default type is int */
	if (short_option)
	    head = tail = mk_type(bt_short, 2);
	else
	    head = tail = mk_type(bt_long, 4);
	break;
    case kw_float:
	head = tail = mk_type(bt_float, 4);
	getsym();
	break;
    case kw_double:
	/* double means really float */
	head = tail = mk_type(bt_float, 4);
	getsym();
	break;
    case kw_enum:
	getsym();
	declenum(table);
	break;
    case kw_struct:
	getsym();
	declstruct(bt_struct);
	break;
    case kw_union:
	getsym();
	declstruct(bt_union);
	break;
    }
}

decl1()
{
    TYP 	   *temp1, *temp2, *temp3, *temp4;
    switch (lastst) {
    case id:
	declid = strsave(lastid);
	getsym();
	decl2();
	break;
    case star:
	temp1 = mk_type(bt_pointer, 4);
	temp1->btp = head;
	head = temp1;
	if (tail == NULL)
	    tail = head;
	getsym();
	decl1();
	break;
    case openpa:
	getsym();
	temp1 = head;
	temp2 = tail;
	head = tail = NULL;
	decl1();
	needpunc(closepa);
	temp3 = head;
	temp4 = tail;
	head = temp1;
	tail = temp2;
	decl2();
	temp4->btp = head;
	if (temp4->type == bt_pointer &&
	    temp4->val_flag != 0 && head != NULL)
	    temp4->size *= head->size;
	head = temp3;
	break;
    default:
	decl2();
	break;
    }
}

decl2()
{
    TYP 	   *temp1;
    long	    i;
    switch (lastst) {
    case openbr:
	getsym();
	if (lastst == closebr)
	    i = 0;
	else
	    i = intexpr();
	needpunc(closebr);
	if (lastst == openbr)
	    decl2();
	temp1 = mk_type(bt_pointer, 0);
	temp1->val_flag = 1;
	temp1->btp = head;
	if (head != 0)
	    temp1->size = i * head->size;
	else
	    temp1->size = i;
	head = temp1;
	if (tail == NULL)
	    tail = head;
	decl2();
	break;
    case openpa:
	getsym();
	temp1 = mk_type(bt_func, 4);
	temp1->val_flag = 1;
	temp1->btp = head;
	head = temp1;
	if (lastst == kw_void) {
	    getsym();
	    if (lastst != closepa)
		error (ERR_PARMS);
	}
	if (lastst == closepa)
	    getsym();
	else {
	    if (nparms != 0)
		error(ERR_PARMS);
	    while (lastst == id) {
		names[nparms++] = strsave(lastid);
		getsym();
		if (lastst == comma)
		    getsym();
	    }
	    needpunc(closepa);
	}
	break;
    }
}

int
alignment(tp)
    TYP 	   *tp;
{
    switch (tp->type) {
    case bt_uchar:
    case bt_char:
	return AL_CHAR;
    case bt_enum:
    case bt_ushort:
    case bt_short:
	return AL_SHORT;
    case bt_ulong:
    case bt_long:
	return AL_LONG;
    case bt_pointer:
	if (tp->val_flag)
	    return alignment(tp->btp);
	else
	    return AL_POINTER;
    case bt_func:
	return AL_FUNC;
    case bt_float:
	return AL_FLOAT;
    case bt_double:
	return AL_DOUBLE;
    case bt_struct:
    case bt_union:
	return AL_STRUCT;
    default:
	fprintf(stderr,"DIAG: alignment: illegal type\n");
	return 1;
    }
}

long
declare(table, al, ilc, ztype, regflag)
/*
 * process declarations of the form:
 *
 * <type>	<decl>, <decl>...;
 *
 * leaves the declarations in the symbol table pointed to by table and returns
 * the number of bytes declared. al is the allocation type to assign, ilc is
 * the initial location counter. if al is sc_member then no initialization
 * will be processed. ztype should be bt_struct for normal and in structure
 * declarations and sc_union for in union declarations.
 *
 * regflag: this flag is true only if al==sc_auto or al==sc_member and means
 * 	    that sp->value.i should be stored in a global array as a hint for
 *	    the register allocator.
 */
    TABLE	   *table;
    enum e_sc	    al;
    long	    ilc;
    enum e_bt	    ztype;
    int 	    regflag;
{
    SYM 	   *sp, *sp1;
    TYP 	   *dhead;
    long	    nbytes;
    int		    func_flag;
    int		    no_append;
    nbytes = 0;
    decl(table);
    dhead = head;
    for (;;) {
	declid = 0;
	decl1();
	if (declid != 0) {	/* otherwise just struct tag... */
	    func_flag = 0;
	    if (head->type == bt_func && (lastst == begin || nparms > 0))
		func_flag = 1;
	    sp = (SYM *) xalloc((int) sizeof(SYM));
	    sp->name = declid;
	    sp->storage_class = al;
	    while ((ilc + nbytes) % alignment(head))
		nbytes++;
	    if (al == sc_static)
		sp->value.i = nextlabel++;
	    else if (ztype == bt_union)
		sp->value.i = ilc;
	    else if (al != sc_auto)
		sp->value.i = ilc + nbytes;
	    else
		sp->value.i = -(ilc + nbytes + head->size);

	    if (regptr < REG_LIST && regflag)
		reglst[regptr++] = sp->value.i;

	    sp->tp = head;
/*
 **************************************************************************
 */
/*
 * The following stuff deals with inconsistencies in the
 * C syntax and semantics, namely the scope of locally
 * declared functions and its default storage class (extern,
 * not auto) etc.
 */
	    no_append = 0;
/*
 * The flag no_append will be set if some stuff is forwarded to the
 * global symbol table here and thus should not be repeated in the local
 * symbol table
 */
/*
 * global function declarations without function body are external
 */
	    if (sp->tp->type == bt_func && sp->storage_class == sc_global
					&& !func_flag) {
		sp->storage_class = sc_external;
	    }
/*
 * [auto] int test() is not an auto declaration, it should be
 * external
 */
	    if (sp->tp->type == bt_func && sp->storage_class == sc_auto) {
		/*
		 * althouh the following if-statement is not necessary since
		 * it this check is performed in append() anyway, it saves
		 * global storage if the functions has previously been
		 * defined.
		 */
		if ((sp1 = search(sp->name, gsyms.tail)) == 0 ) {
		    /* put entry in the global symbol table */
		    ++global_flag;
		    sp1 = (SYM *) xalloc((int) sizeof(SYM));
		    sp1->name = strsave(sp->name);
		    sp1->storage_class = sc_external;
		    sp1->tp = save_type(sp->tp);
		    append(&sp1, &gsyms);
		    --global_flag;
		} else {
		    /* already defined in global symbol table */
		    if (!eq_type(sp->tp,sp1->tp))
			error (ERR_REDECL);
		}
		no_append = 1;
		sp = sp1;
	    }
/*
 * static local function declarations should be put in the
 * global symbol table to retain the compiler generated
 * label number
 */
	    if (sp->tp->type == bt_func && sp->storage_class == sc_static
	     				&& table == &lsyms) {
		if ((sp1=search(sp->name,gsyms.tail)) == 0) {
		    /* put it into the global symbol table */
		    ++global_flag;
		    sp1 = (SYM *) xalloc((int) sizeof(SYM));
		    sp1->name = strsave(sp->name);
		    sp1->storage_class = sc_static;
		    sp1->tp = save_type(sp->tp);
		    sp1->value.i = sp->value.i;
		    append(&sp1, &gsyms);
		    --global_flag;
	    	} else {
		    if (!eq_type(sp->tp,sp1->tp))
			error (ERR_REDECL);
		} 
		no_append = 1;
		sp = sp1;
	    }
/*
 ****************************************************************************
 */
	    if (ztype == bt_union)
		nbytes = imax(nbytes, sp->tp->size);
	    else if (al != sc_external)
		nbytes += sp->tp->size;
	    if (!no_append)
		append(&sp, table);
	    if (func_flag) {
		/* function body follows */
		int		local_nparms = nparms;
		ret_type = sp->tp->btp;
		if (!global_flag)
		    error(ERR_SYNTAX);
		nparms = 0;
		funcbody(sp, names, local_nparms);
		return nbytes;
	    }
	    if ((al == sc_global || al == sc_static) &&
		sp->tp->type != bt_func)
		doinit(sp, alignment(head));
	    else if (lastst == assign)
		if (al == sc_auto)
		    auto_init(sp);
		else {
		    error(ERR_ILLINIT);
		    doinit(sp, alignment(head));
		}
	} else
	    /* don''t accept struct tags with size <= 0 */
	if (head->size <= 0)
	    error(ERR_SIZE);

	if (lastst == semicolon)
	    break;
	needpunc(comma);
	if (declbegin(lastst) == 0)
	    break;
	head = dhead;
    }
    getsym();
    return nbytes;
}

int
declbegin(st)
    enum e_sym	    st;
{
    return st == star || st == id || st == openpa ||
	st == openbr;
}

declenum(table)
    TABLE	   *table;
{
    SYM 	   *sp;
    TYP 	   *tp;
    if (lastst == id) {
	if ((sp = search(lastid, ltags.tail)) == 0 &&
	    (sp = search(lastid, gtags.tail)) == 0) {
	    sp = (SYM *) xalloc((int) sizeof(SYM));
	    sp->tp = (TYP *) xalloc((int) sizeof(TYP));
	    sp->tp->type = bt_enum;
	    sp->tp->size = 2;
	    sp->tp->lst.head = 0;
	    sp->tp->btp = 0;
	    sp->tp->st_flag = global_flag;
	    sp->storage_class = sc_type;
	    sp->name = strsave(lastid);
	    sp->tp->sname = sp->name;
	    getsym();
	    if (lastst != begin)
		error(ERR_INCOMPLETE);
	    else {
		if (global_flag)
		    append(&sp, &gtags);
		else
		    append(&sp, &ltags);
		getsym();
		enumbody(table);
	    }
	} else
	    getsym();
	head = sp->tp;
    } else {
	tp = mk_type(bt_enum,2);
	if (lastst != begin)
	    error(ERR_INCOMPLETE);
	else {
	    getsym();
	    enumbody(table);
	}
	head = tp;
    }
}

enumbody(table)
    TABLE	   *table;
{
    int 	    evalue;
    int 	    first = 1;
    SYM 	   *sp;
    evalue = 0;
    while (lastst == id) {
	sp = (SYM *) xalloc((int) sizeof(SYM));
	sp->value.i = evalue++;
	sp->name = strsave(lastid);
	sp->storage_class = sc_const;
	sp->tp = &tp_econst;
	append(&sp, table);
	getsym();
	if (first && lastst == assign) {
	    getsym();
	    evalue = sp->value.i = intexpr();
	    evalue++;
	}
	first = 0;
	if (lastst == comma)
	    getsym();
	else if (lastst != end)
	    break;
    }
    needpunc(end);
}

declstruct(ztype)
/*
 * declare a structure or union type. ztype should be either bt_struct or
 * bt_union.
 *
 * References to structures/unions not yet declared are allowed now. The
 * declaration has to be done before the structure is used the first time
 */
    enum e_bt	    ztype;
{
    SYM 	   *sp;
    TYP 	   *tp;
    if (lastst == id) {
	if ((sp = search(lastid, ltags.tail)) == 0 &&
	    (sp = search(lastid, gtags.tail)) == 0) {
	    sp = (SYM *) xalloc((int) sizeof(SYM));
	    sp->name = strsave(lastid);
	    sp->tp = mk_type(ztype,0);
	    sp->tp->lst.head = 0;
	    sp->storage_class = sc_type;
	    sp->tp->sname = sp->name;
	    if (global_flag)
		append(&sp, &gtags);
	    else
		append(&sp, &ltags);
	}
	if (sp->tp->lst.head != 0)
	    getsym();
	else {
	    getsym();
	    /* allow, e.g. struct x *p; before x is defined */
	    if (lastst == begin) {
		getsym();
		structbody(sp->tp, ztype);
	    }
	}
	head = sp->tp;
    } else {
	tp = mk_type (ztype,0);
	tp->sname = 0;
	tp->lst.head = 0;
	if (lastst != begin)
	    error(ERR_INCOMPLETE);
	else {
	    getsym();
	    structbody(tp, ztype);
	}
	head = tp;
    }
}

structbody(tp, ztype)
    TYP 	   *tp;
    enum e_bt	    ztype;
{
    long	    slc;
    slc = 0;
    /* tp->val_flag = 1; */
    while (lastst != end) {
	if (ztype == bt_struct)
	    slc += declare(&(tp->lst), sc_member, slc, ztype, 0);
	else
	    slc = imax(slc, declare(&tp->lst, sc_member, 0l, ztype, 0));
    }
    /*
     * make size even==default_alignment, to allow arrays of this structure
     */
    /* DEFAULTALIGNMENT */
    if (slc & 1)
	slc++;
    tp->size = slc;
    getsym();
}

compile()
/*
 * main compiler routine. this routine parses all of the declarations using
 * declare which will call funcbody as functions are encountered.
 */
{
    while (lastst != eof) {
	dodecl(sc_global);
	if (lastst != eof)
	    getsym();
    }
    dumplits();
}

dodecl(defclass)
    enum e_sc	    defclass;
{
    SYM 	   *sp;
    int 	    regflag;
    long	    slc = 0;
    for (;;) {
	regflag = 0;
	switch (lastst) {
	case kw_register:
	    regflag = 1;
	    getsym();
	    if (defclass != sc_auto && defclass != sc_member)
		error(ERR_ILLCLASS);
	    goto do_decl;
	    /* CVW */
	case kw_auto:
	    getsym();
	    if (defclass != sc_auto)
		error(ERR_ILLCLASS);
	    goto do_decl;
	case id:
	    /*
	     * CVW  If it is a typedef identifier, do the declaration.
	     */
	    if ((sp = gsearch(lastid)) != 0 && sp->storage_class == sc_typedef)
		goto do_decl;
	    /* else fall through */
	    /* CVW */
	    /*
	     * If defclass == sc_global (we are outside any function), almost
	     * anything can start a declaration, look, e.g. mined:
	     * (*escfunc(c))() ,,almost anything'' is not exact: id (no
	     * typedef id), star, or openpa.
	     */
	case openpa:
	case star:
	    if (defclass == sc_global)
		goto do_decl;
	    return;
	    /* else fall through to declare	 */
	case kw_char:
	case kw_short:
	case kw_unsigned:
	case kw_long:
	case kw_struct:
	case kw_union:
	case kw_enum:
	case kw_void:
	case kw_float:
	case kw_double:
	case kw_int:
    do_decl:
	    if (defclass == sc_global)
		declare(&gsyms, sc_global, 0l, bt_struct, 0);
	    else if (defclass == sc_auto)
		lc_auto +=
		    declare(&lsyms, sc_auto, lc_auto, bt_struct, regflag);
	    else		/* defclass == sc_member (parameter decl.) */
		slc +=
		    declare(&lsyms, sc_auto, slc, bt_struct, regflag);
	    break;
	case kw_static:
	    getsym();
	    if (defclass == sc_member)
		error(ERR_ILLCLASS);
	    if (defclass == sc_auto)
		declare(&lsyms, sc_static, 0l, bt_struct, 0);
	    else
		declare(&gsyms, sc_static, 0l, bt_struct, 0);
	    break;
	case kw_typedef:
	    getsym();
	    if (defclass == sc_member)
		error(ERR_ILLCLASS);
	    if (defclass == sc_auto)
		declare(&lsyms, sc_typedef, 0l, bt_struct, 0);
	    else
		declare(&gsyms, sc_typedef, 0l, bt_struct, 0);
	    break;
	case kw_extern:
	    getsym();
	    if (defclass == sc_member)
		error(ERR_ILLCLASS);
	    ++global_flag;
	    declare(&gsyms, sc_external, 0l, bt_struct, 0);
	    --global_flag;
	    break;
	default:
	    return;
	}
    }
}

int
eq_type(tp1,tp2)
TYP *tp1,*tp2;
/*
 * This is used to tell valid from invalid redeclarations
 */
{
if (tp1 == 0 || tp2 == 0) return 0;

if (tp1 == tp2) return 1;

if (tp1->type != tp2->type) return 0;

if (tp1->type == bt_pointer || tp1->type == bt_func)
	return eq_type(tp1->btp,tp2->btp);

if (tp1->type == bt_struct || tp1->type == bt_union)
	return (tp1->lst.head == tp2->lst.head);

return 1;
}

TYP *save_type(tp)
TYP *tp;
{
TYP *ret_tp;
/* the type structure referenced by tp may be in local tables.
   Copy it to global tables and return a pointer to it.
 */
if (tp->st_flag != 0) return tp;
++global_flag;
ret_tp = (TYP *) xalloc ((int) sizeof(TYP));

/* copy TYP structure */
*ret_tp = *tp;
ret_tp->st_flag = global_flag;

if (tp->type == bt_func || tp->type == bt_pointer)
	ret_tp->btp = save_type(tp->btp);

if (tp->type == bt_struct || tp->type == bt_union) {
    /*
     * It consumes very much memory to duplicate the symbol table,
     * so we don't do it.
     * I think we needn't do it if it is in local tables.
     */
     fprintf(stderr,"warning: didn't copy local struct/union in save_type\n");
     ret_tp->lst.head = (SYM *) 0;
     ret_tp->lst.tail = (SYM *) 0;
}
--global_flag;
return ret_tp;
}
