/*
 * 68000 C compiler
 *
 * Copyright 1984, 1985, 1986 Matthew Brandt. all commercial rights reserved.
 *
 * This compiler is intended as an instructive tool for personal use. Any use
 * for profit without the written consent of the author is prohibited.
 *
 * This compiler may be distributed freely for non-commercial use as long as
 * this notice stays intact. Please forward any enhancements or questions to:
 *
 * Matthew Brandt Box 920337 Norcross, Ga 30092
 *
 * This compiler has been enhanced and corrected at the end of 1989 by Christoph
 * van Wullen, who generated this version. Look at the file README.CVW for
 * further comments.
 */

/* compiler header file	 */


enum e_sym {
    id, cconst, iconst, lconst, sconst, rconst, plus, minus,
    star, divide, lshift, rshift, modop, eq, neq, lt, leq, gt,
    geq, assign, asplus, asminus, astimes, asdivide, asmodop,
    asuparrow,
    aslshift, asrshift, asand, asor, autoinc, autodec, hook, compl,
    comma, colon, semicolon, uparrow, openbr, closebr, begin, end,
    openpa, closepa, pointsto, dot, lor, land, not, or, and, kw_int,
    kw_void, kw_char, kw_float, kw_double, kw_struct, kw_union,
    kw_long, kw_short, kw_unsigned, kw_auto, kw_extern,
    kw_register, kw_typedef, kw_static, kw_goto, kw_return,
    kw_sizeof, kw_break, kw_continue, kw_if, kw_else, kw_for,
    kw_do, kw_while, kw_switch, kw_case, kw_default, kw_enum,
    uconst, eof
};

enum e_sc {
    sc_static, sc_auto, sc_global, sc_external, sc_type, sc_const,
    sc_member, sc_label, sc_ulabel, sc_typedef
};

/* CVW change: add bt_void */
enum e_bt {
    bt_char, bt_short, bt_long, bt_float, bt_double, bt_pointer,
    bt_ulong, bt_struct, bt_union, bt_enum, bt_func,
    bt_void, bt_uchar, bt_ushort
};

struct slit {
    struct slit    *next;
    int 	    label;
    char	   *str;
};

struct sym {
    struct sym	   *next;
    /* cvw: doubly linked */
    struct sym	   *prev;
    char	   *name;
    enum e_sc	    storage_class;
    int 	    used;
    union {
	long		i;
	unsigned long	u;
	char	       *s;
    }
		    value;

    struct typ {
	enum e_bt	type;
	int		val_flag;	/* is it a value type */
	long		size;
	struct stab {
	    struct sym	   *head, *tail;
	}		lst;
	struct typ     *btp;
	char	       *sname;
	int		st_flag;	/* is it in local or global storage */
    }
		   *tp;
};

#define SYM	struct sym
#define TYP	struct typ
#define TABLE	struct stab

#define MAX_STRLEN	500

#define ERR_SYNTAX	0	/* general error */
#define ERR_ILLCHAR	1	/* illegal character */
#define ERR_FPCON	2	/* illegal floating-point constant */
#define ERR_ILLTYPE	3	/* illegal type */
#define ERR_UNDEFINED	4	/* undefined identifier */
#define ERR_DUPSYM	5	/* duplicate symbol */
#define ERR_PUNCT	6	/* expected symbol not found */
#define ERR_IDEXPECT	7	/* identifier expected */
#define ERR_NOINIT	8	/* initialization invalid */
#define ERR_INCOMPLETE	9
#define ERR_ILLINIT	10	/* illegal initialization */
#define ERR_INITSIZE	11	/* too many initializers */
#define ERR_ILLCLASS	12	/* illegal storage class */
#define ERR_BLOCK	13
#define ERR_NOPOINTER	14	/* pointer type expected */
#define ERR_NOFUNC	15	/* function type expected */
#define ERR_NOMEMBER	16	/* struct/union member expected */
#define ERR_LVALUE	17	/* l-value required */
#define ERR_DEREF	18	/* error dereferencing a pointer */
#define ERR_MISMATCH	19	/* type mismatch error */
#define ERR_EXPREXPECT	20	/* expression expected */
#define ERR_WHILEXPECT	21	/* 'while' expected in do-loop */
#define ERR_DUPCASE	23	/* duplicate case label */
#define ERR_LABEL	24	/* undefined label */
#define ERR_PREPROC	25	/* Problem with CPP output */

#define ERR_CAST	29	/* error doing a cast */
#define ERR_INTEGER	30	/* integer-valued type expected */
#define ERR_CASTCON	31
#define ERR_COMP	32
#define ERR_PARMS	33
#define ERR_SIZE	34
#define ERR_REDECL	35	/* illegal redeclaration */
#define ERR_INTEXPR	36	/* illegal constant integer expression */

/* alignment sizes	 */

#define AL_CHAR 	1
#define AL_SHORT	2
#define AL_LONG 	2
#define AL_POINTER	2
#define AL_FLOAT	2
#define AL_DOUBLE	2
#define AL_STRUCT	2
#define AL_FUNC		2

/* SUN compiler have a reserved word ,,inline'' */
#define inline jnline

char	       *strcpy();


int	       *xalloc();
SYM	       *search();
SYM	       *gsearch();
char	       *strsave();
TYP	       *primary();
TYP	       *expression();
TYP	       *unary();
TYP	       *exprnc();
TYP	       *cast_op();
TYP	       *mk_type();
long		intexpr();
void		getch();
void		error();
void		getsym();
void		needpunc();
void		initsym();
void		append();
TYP	       *save_type();
