/*
*	@(#)zmachine.c	2.24
*/

# include "zmachine.h"

char *story_name;
struct dev *printer;

jmp_buf restart_buf;

/************************************************************************/
int release;
int status_type;

BYTE *ff0;
BYTE *fec;
char *terms, *my_terms;		/* word terminators		*/
BYTE *first_word, *last_word;
UWORD word_len, word_num;

char *line;			/* line buffer during status	*/
int use_line = 0;		/* line output			*/
UWORD *stack, *framep, *sp;	/* stack management		*/

#ifdef DEBUG
UWORD ops_ix = 0;
struct {
	BYTE c_op;
	struct address c_pc;
	UWORD c_sp;
	UWORD c_fp;
} ops[256];
#endif

BYTE *short_cuts;
int save_len;
int status_len;			/* number of status lines	*/

int line_cnt;

int in_status = 1;

/************************************************************************/

WORD l116b2(d0)
register WORD d0;
{
	WORD l116ca();

	if (--d0 < 0)
		return(fetchw_op());
	else if (d0 == 0)
		return(fetchb_op());
	else if ((d0 = fetchb_op()) != 0)
		return(l116ca(d0));
	else 
		return(*(sp++));
}

WORD l116c2(d0)
WORD d0;
{
	WORD l116ca();

	if (!d0)
		return(*sp);
	else
		return(l116ca(d0));
}

WORD l116ca(d0)
WORD d0;
{
	if (d0 < 0x10)
		return(framep[- d0 + 1]);
	else
		return(word_get(&fec[(d0 - 0x10)*2]));
}

void l116ee(d0, d1)
WORD d0, d1;
{
	if (!d0)
		*sp = d1;
	else
		if (d0 < 0x10)
			framep[- d0 + 1] = d1;
		else
			word_put(&fec[(d0 - 0x10)*2], d1);
}

void l11720(d0)
WORD d0;
{
	WORD d1;

	if (d1 = fetchb_op())
		l116ee(d1, d0);
	else
		*(--sp) = d0;
}

void l1171c(d0)
WORD d0;
{
	l11720(d0 & 0xff);
}

#ifdef DEBUG
void zcore_dump()
{
	int i, ix;
	FILE *fp;

	fp = fopen("zcore", "w");
	if (!fp)
		fp = stderr;

	fprintf(fp, "sp = %04x  fp = %04x\n", sp-stack, framep-stack);

	fprintf(fp, "Stack:");
	for (i = 0; i < 256; i++)
	{
		if (!(i % 8))
			fprintf(fp, "\n%04x: ", i);

		fprintf(fp, "%04x ", stack[i]);
	}

	fprintf(fp, "\nLast instructions(fp:sp:addr:op):\n");
	for (i = 256; i; i--)
	{
		ix = (ops_ix++ & 0xff);
		if (!(i % 4))
			fprintf(fp, "\n");

		fprintf(fp, "%02x:%02x:%05lx:%02x ", ops[ix].c_fp, ops[ix].c_sp,
		(long)ops[ix].c_pc.offset|((long)ops[ix].c_pc.segment<<9),
		ops[ix].c_op);
	}
	fprintf(fp, "\n");
	unlink("zcore.sav");
	save_gf("zcore.sav");
}
#endif

/************************************************************************/
/*				op-codes				*/

/************************************************************************/
/*			op-code utilities				*/

# define dojmp()	jump(0)
# define dontjmp()	jump(1)

void jump(d1)
register WORD d1;
{
	register WORD d0;
	void ret_0(), ret_1();

	d0 = fetchb_op();
	if(d0 & 0x80)
		d1++;

	d0 &= ~0x80;

	if (!(d0 & 0x40))
	{
		d0 &= ~0x40;
		d0 <<= 8;
		d0 |= fetchb_op();
		if (d0 & 0x2000)
			d0 |= ~0x3fff;
	}
	else
		d0 &= ~0x40;

	if (--d1)
	{
		if (!d0)
			ret_0();
		else if (!(--d0))
			ret_1();
		else
		{
			pc.offset += (d0 - 1);
			load_code();
		}
	}
}

BYTE *l11846(d0)
WORD d0;
{
	return(ff0+9*d0+0x35);
}

BYTE *l11856(a0)
BYTE *a0;
{
	register BYTE *p;
	register WORD d;

	p = main_p + word_get(a0+7);
	d = *(p++)*2;
	return(p + d);
}

BYTE *l11870(a0)
BYTE *a0;
{
	register WORD d;

	d = (*(a0++)>>5) + 1;
	return(a0 + d);
}

void illegal()
{
#ifdef DEBUG
	zcore_dump();
#endif
	fatal("Bad operation", story_name);
}

/************************************************************************/
/*				class 0					*/

void ret_1()
{
	void ret();
	ret(1);
}

void ret_0()
{
	void ret();
	ret(0);
}

void print_im()
{
	decode(&pc);
	load_code();
}

void printcr_im()
{
	void newline();
	print_im();
	newline();
	ret_1();
}

void nop()
{
}

void save_g()
{
	char *name;
	int save_gf();
	
	if (!(name = read_sname()))
		dojmp();
	else
		jump(save_gf(name));
}

int save_gf(p)
char *p;
{
	extern char *iovers;
	UWORD *csp;

	if (open_save_w(p))
		return(0);

	csp = sp;
	*(--sp) = pc.segment;
	*(--sp) = pc.offset;
#ifdef GEMDOS
	/* sorry, its awful but compatibel to infocom's interpreter */
	*(--((long *)sp)) = (BYTE *)framep - (BYTE *)stack;
	*(--sp) = release;
	*(((long *)stack)) = (BYTE *)sp - (BYTE *)stack;
	*(stack + sizeof(long)/sizeof(UWORD)) = atoi(iovers);
#else
	*(--sp) = framep - stack;
	*(--sp) = release;
	*stack = sp - stack;
	*(stack + 1) = atoi(iovers);
#endif
	sp = csp;

	if (write_save(0, 1, stack))
		return(0);

	if (write_save(1, save_len, main_p))
		return(0);

	if (save_keys())
		return(0);

	if (close_save())
		return(0);

	return(1);
}

void restore_g()
{
	char *name;
	int restore_gf();
	
	if (!(name = read_rname()))
		dojmp();
	else
		jump(restore_gf(name));
}

int restore_gf(p)
char *p;
{
	extern char *iovers;
	int sv;

	if (open_save_r(p))
		return(0);

	if (read_save(0, 1, stack))
		fatal("Save file read error", p);

#ifdef GEMDOS
	sp = (UWORD *)((BYTE *)stack + *((long *)stack));
#else
	sp = stack + *stack;
#endif

	if (*sp++ != release)
		fatal("Wrong save file version", p);

#ifdef GEMDOS
	framep = (BYTE *)stack + *(((long *)sp)++);
#else
	framep = stack + *sp++;
#endif
	pc.offset = *(sp++);
	pc.segment = *(sp++);

	sv = word_get(main_h->reserved5);
	if (read_save(1, save_len, main_p))
		fatal("Save file read error", p);
	word_put(main_h->reserved5, sv);

#ifdef GEMDOS
	if (*(stack + sizeof(long)/sizeof(UWORD)) == atoi(iovers))
#else
	if (*(stack + 1) == atoi(iovers))
#endif
		if (restore_keys())
			fatal("Save file read error", p);

	close_save();
	load_code();

	return(1);
}
	
void restart_g()
{
	line_cnt = 0;
	output_chr('\n');
	longjmp(restart_buf);
}

void ret_sp()
{
	void ret();
	ret(*(sp++));
}

void inc_sp()
{
	sp++;
}

void halt()
{
	clean_up();
	exit(userexit(0));
}

void newline()
{
	output_chr('\n');
}

void status()
{
	char	room[256];
	char	*score;
	char	am_pm;
	int	hour;

	void	write_num();
	void	l11e24();

	use_line = 1;
	line = room;

	*line++ = ' ';
	l11e24(l116c2(0x10));
	*(line++) = '\0';
	score = line;
	if (!status_type)
	{
		strcpy(line, "Score: ");
		write_num(l116c2(0x11));
		*line++ = '/';
		write_num(l116c2(0x12));
	}
	else
	{
		if ((hour = l116c2(0x11)) > 12)
		{
			hour -= 12;
			am_pm = 'p';
		}
		else
			am_pm = 'a';

		if (hour == 0)
			hour = 12;

/*
		sprintf(line, "Time: %2d:%02d %cm", hour, l116c2(0x12), am_pm);
*/
		strcpy(line, "Time: ");
		line += strlen(line);
		if (hour < 10)
			*line++ = ' ';
		write_num(hour);
		*line++ = ':';
		if (l116c2(0x12) < 10)
			*line++ = '0';
		write_num(l116c2(0x12));
		*line++ = ' ';
		*line++ = am_pm;
		*line++ = 'm';
	}
	*line++ = ' ';
	*line++ = '\0';
	output_status(room, score);
	use_line = 0;
}

void verify()
{
	struct address a, end;
	int m_len;
	long sum;

	output_str("Z-Code 3 interpreter V2.24 for ");
	output_str(sysname);
	output_str("\n");

	m_len = main_l;
	main_l = 0;

	a.segment = 0;
	a.offset = 0x40;
	sum = 0;
	waddr_to_vaddr(&end, word_get(main_h->len));

	while(a.segment != end.segment || a.offset != end.offset)
		sum += fetchb_data(&a);

	main_l = m_len;

	jump((UWORD)sum == word_get(main_h->checksum));
}

/************************************************************************/
/*				class 1					*/

void bne(d0)
WORD d0;
{
	if(d0)
		dojmp();
	else
		dontjmp();
}

void l1190c(d0)
WORD d0;
{
	register BYTE d1;

	l11720(d1 = l11846(d0)[5]);

	if (d1)
		dontjmp();
	else
		dojmp();
}

void l118f2(d0)
WORD d0;
{
	register BYTE d1;

	l11720(d1 = l11846(d0)[6]);

	if (d1)
		dontjmp();
	else
		dojmp();
}

void l118e4(d0)
WORD d0;
{
	l11720(l11846(d0)[4]);
}

void l11a7e(d0)
WORD d0;
{
	l11720((main_p[d0-1]>>5)+1);
}

void l11aac(d0)
WORD d0;
{
	l116ee(d0,l116c2(d0)+1);
}

void l11aba(d0)
WORD d0;
{
	l116ee(d0,l116c2(d0)-1);
}

void print_near(d0)
WORD d0;
{
	struct address a;
	baddr_to_vaddr(&a,d0);
	decode(&a);
}

void l118a2(d1)
WORD d1;
{
	register BYTE *a0, *a1;
	register UWORD d0;

	a1 = l11846(d1);
	if (d0 = a1[4])
	{
		d0 = (a0 = l11846(d0))[6];
		if (d1 == d0)
			a0[6] = a1[5];
		else
		{
			while ((d0 = (a0 = l11846(d0))[5]) != d1)
				;
			a0[5] = a1[5];
		}
		a1[4] = a1[5] = 0;
	}
}

void l11e24(d0)
WORD d0;
{
	struct address a;

	baddr_to_vaddr(&a, word_get(l11846(d0)+7) + 1);
	decode(&a);
}

void ret(d0)
WORD d0;
{
	sp = framep + 1;
#ifdef GEMDOS
	framep = (BYTE *)stack + *(((long *)sp)++);
#else
	framep = stack + *sp++;
#endif
	pc.offset = *(sp++);
	pc.segment = *(sp++);
	load_code();
	l11720(d0);
}

void bra(d0)
WORD d0;
{
	pc.offset += (d0 - 2);
	load_code();
}

void print_far(d0)
WORD d0;
{
	struct address a;
	waddr_to_vaddr(&a, d0);
	decode(&a);
}

void l11a96(d0)
WORD d0;
{
	l11720(l116c2(d0));
}

void not(d0)
WORD d0;
{
	l11720(~d0);
}

/************************************************************************/
/*				class 2					*/

void l11824(a0)
register WORD *a0;
{
	register WORD d0, d1;

	d1 = *(a0++) - 1;
	d0 = *(a0++);

	for(;;)
		if(*(a0++) == d0)
		{
			dontjmp();
			break;
		}
		else if (!--d1)
		{
			dojmp();
			break;
		}
}

void cbge(d0, d1)
WORD d0, d1;
{
	jump(d0 < d1);
}

void cble(d0, d1)
WORD d0, d1;
{
	jump(d0 > d1);
}

void dcbge(d0, d1)		/* decrement, compare and jump greater equal */
WORD d0, d1;			/* dcbge */
{
	register WORD d2;

	d2 = l116c2(d0) - 1;
	l116ee(d0,d2);
	if (d2 < d1)
		dontjmp();
	else
		dojmp();
}

void icble(d0, d1)		/* increment, compare and jump less equal */
WORD d0, d1;			/* icble */
{
	register WORD d2;

	d2 = l116c2(d0) + 1;
	l116ee(d0,d2);
	if (d2 > d1)
		dontjmp();
	else
		dojmp();
}

void l11926(d0, d1)
WORD d0, d1;
{
	if (l11846(d0)[4] == d1)
		dontjmp();
	else
		dojmp();
}

void l11806(d0, d1)
WORD d0, d1;
{
	jump((d1 & ~d0) == 0);
}

void or(d0, d1)
WORD d0, d1;
{
	l11720(d0 | d1);
}

void and(d0, d1)
{
	l11720(d0 & d1);
}

#define tst(a0, d0)	(a0[d0 >> 3] & (1<<((~d0)&7)))
#define clr(a0, d0)	(a0[d0 >> 3] &= ~(1<<((~d0)&7)))
#define set(a0, d0)	(a0[d0 >> 3] |= (1<<((~d0)&7)))

void tstbit_jz(d0, d1)
WORD d0, d1;
{
	if (tst(l11846(d0), d1))
		dontjmp();
	else
		dojmp();
}

void setbit(d0, d1)
WORD d0, d1;
{
	set(l11846(d0), d1);
}

void clrbit(d0, d1)
WORD d0, d1;
{
	clr(l11846(d0), d1);
}

void l11a9e(d0, d1)
WORD d0, d1;
{
	l116ee(d0, d1);
}

void l1187c(d0, d1)
WORD d0, d1;
{
	register BYTE *a0, *a1;
	void l118a2();

	l118a2(d0);
	a1 = l11846(d1);
	a0 = l11846(d0);

	a0[5] = a1[6];
	a0[4] = d1;
	a1[6] = d0;
}

void l11a16(d0, d1)
WORD d0, d1;
{
	struct address a;
	baddr_to_vaddr(&a, d0 + d1 * 2);
	l11720(fetchw_data(&a));
}

void l11a28(d0, d1)
WORD d0, d1;
{
	struct address a;
	baddr_to_vaddr(&a, d0 + d1);
	l1171c(fetchb_data(&a));
}

void l11936(d0, d1)
register WORD d0, d1;
{
	register BYTE *a0;

	for (a0 = l11856(l11846(d0)); d1 < (d0 = *a0 & 0x1f); a0 = l11870(a0))
		;

	if (d1 == d0)
	{
		if (!(*(a0++) & 0x20))
			l1171c(*a0);
		else
			l11720(word_get(a0));
	}
	else
		l11720(word_get(&ff0[(d1-1) * 2]));
	
}

void l11a54(d0, d1)
register WORD d0, d1;
{
	register BYTE *a0;

	for (a0 = l11856(l11846(d0)); d1 < (d0 = *a0 & 0x1f); a0 = l11870(a0))
		;

	if (d1 != d0)
		l11720(0);
	else
		l11720(++a0 - main_p);
}

void l119a4(d0, d1)
register WORD d0, d1;
{
	register BYTE *a0;

	a0 = l11856(l11846(d0));

	if (d1)
	{
		for(;  d1 < (d0 = *a0 & 0x1f); a0 = l11870(a0))
			;
		if (d1 != d0)
			fatal("Non-existant next property", story_name);
		else
			a0 = l11870(a0);
	}
	l11720(*a0 & 0x1f);
}

void add(d0, d1)
WORD d0, d1;
{
	l11720(d0 + d1);
}

void sub(d0, d1)
WORD d0, d1;
{
	l11720(d0 - d1);
}

void mul(d0, d1)
WORD d0, d1;
{
	l11720(d0 * d1);
}

void div(d0, d1)
WORD d0, d1;
{
	l11720(d0 / d1);
}

void mod(d0, d1)
WORD d0, d1;
{
	l11720(d0 % d1);
}

void call(a0)
register WORD *a0;
{
	register WORD d0, d1, d2;

	d2 = *(a0++);
	if ((d0 = *(a0++)) == 0)
		l11720(0);
	else
	{
		d2--;
		*(--sp) = pc.segment;
		*(--sp) = pc.offset;
#ifdef GEMDOS
		*(--((long *)sp)) = (BYTE *)framep - (BYTE *)stack;
#else
		*(--sp) = framep - stack;
#endif
		waddr_to_vaddr(&pc,d0);
		load_code();
		framep = sp - 1;
		if (d1 = fetchb_op())
		{
			do
			{
				d0 = fetchw_op();
				if (--d2 >= 0)
					d0 = *(a0++);
				*(--sp) = d0;
			}
			while (--d1 > 0);
		}
	}
}

void l11a38(d0, d1, d2)
WORD d0, d1, d2;
{
	word_put(&main_p[d0 + d1 * 2], d2);
}


void l11a48(d0, d1, d2)
WORD d0, d1; WORD d2;
{
	main_p[d0+d1] = (BYTE)d2;
}

void l1196e(d0, d1, d2)
register WORD d0, d1; WORD d2;
{
	register BYTE *a0;

	for (a0 = l11856(l11846(d0)); d1 < (d0 = *a0 & 0x1f); a0 = l11870(a0))
		;

	if (d1 != d0)
		fatal("Non-existant put property", story_name);

	if (*(a0++) & 0x20)
		word_put(a0, d2);
	else
		*a0 = d2;
}

UWORD findword(a0)
UWORD *a0;
{
	register UWORD d0, step, code0, code1;
	register BYTE *word;

	d0 = word_num;
	step = word_len;

	code0 = *a0;
	code1 = *(a0+1);

	for ( d0 >>= 1, step <<= 1; d0 >>= 1; step <<= 1)
		;

	word = &first_word[step - word_len];
	
	do
	{
		step >>= 1;
		d0 = word_get(word);
		if (code0 <= d0)
		{
			if (code0 != d0)
				word -= step;
			else
			{
				d0 = word_get(word+2);
				if (code1 <= d0)
				{
					if (code1 != d0)
						word -= step;
					else
						return(word - main_p);
				}
				else
				{
					word += step;
					if (last_word < word)
						word = last_word;
				}
			}
		}
		else
		{
			word += step;
			if (last_word < word)
				word = last_word;
		}
	}
	while(word_len <= step);
	return(0);
}

char *wordend(c)
register char c;
{
	register char *p;

	for(p = terms; *p; p++)
		if (*p == c)
			return (p);
	return(NULL);
}

void input(a0)
WORD *a0;
{
	char c;
	char *inp;		/* input field				*/
	char *end;		/* end of input line			*/
	BYTE *out;		/* output field				*/
	BYTE *outp;		/* pointer into output field		*/
	char src_word[8];	/* source word				*/
	UWORD dst_word[4];	/* word coded in z-code			*/
	register char *lp;	/* pointer into line			*/
	register char *cp;	/* pointer into src_word		*/
	char *ws;		/* pointer into line (start of line)	*/
	register int wc;	/* word count				*/
	register char *p;	/* scratch				*/
	static struct hist_buf history = {I_HIST_LEN, NULL, NULL};
				/* history buffer			*/

	if (!history.hb)
	{
		if (!(history.undo = history.hb = malloc(history.len)))
			no_mem_error();
		else
			history.hb[0] = history.hb[1] = '\0';
	}

	inp = (char *)&main_p[a0[1]];
	out = &main_p[a0[2]];

	status();
	output_chr(FLUSH);

	end = read_str(inp, &history);

	lp = inp + 1;
	outp = out + 2;
	wc = 0;

	for(;;)
	{
		cp = src_word;
		ws = lp;
		while (lp < end)
		{
			if (p = wordend(c = *lp++))
				break;
			else
				if (cp < src_word + 6)
					*cp++ = c;
		}

		if (lp < end)
		{
			if (cp != src_word)
				lp--;
			else if (p < my_terms)
				*cp++ = c;
			else
				continue;
		}
		else
		{
			if (src_word == cp)
				break;
		}

		if (++wc >= out[0])
		{
			output_chr('\n');
			output_str("too many words for internal buffer\n");
			out[1] = 0;
			return;
		}

		outp[2] = (char)(lp - ws);
		outp[3] = (char)(ws - inp);
		*cp = '\0';
		encode(dst_word, src_word);
		word_put(outp, findword(dst_word));
		outp += 4;
	}
	out[1] = wc;

	if (word_get(main_h->reserved5) & 1)
	{
		for (p = inp; *++p; )
			putc_dev(*p, printer);
		putc_dev('\n', printer);
	}
}

void l11dcc(d0)
WORD d0;
{
	output_chr(d0);
}

void write_num(d0)
WORD d0;
{
	char buf[16];
	register char *p;
	int flag;

	flag = 0;
	if (d0 < 0)
	{
		flag = 1;
		d0 = -d0;
	}

	p = buf + 15;
	*p = '\0';
	do
		*--p = d0 % 10 + '0';
	while(d0 /= 10);

	if (flag)
		*--p = '-';
	
	output_str(p);
}

void rnd(d0)
WORD d0;
{
	extern long zrandom();
/*
	static UWORD rnd0 = 0xffff, rnd1 = 0;
	register long d1;

	if (rnd0 == 0xffff)
	{
		d1 = Random();
		rnd0 = d1 >> 16;
		rnd1 = d1;
	}

	d1 = rnd0;
	d1 |= (rnd0 = rnd1) << 16;
	d1 >>= 1;
	d1 = (rnd1 ^= d1);
	d1 &= 0x7fff;
	l11720(((UWORD)d1 % d0) + 1);
*/
	l11720((((UWORD)zrandom() & (UWORD)0x7fff) % d0) + 1);
}

void l11aa2(d0)
WORD d0;
{
	*(--sp) = d0;
}

void l11aa6(d0)
WORD d0;
{
	l116ee(d0, *(sp++));
}

void l11e5e(d0)
WORD d0;
{
	status_len = d0;
}

void l11e7e(d0)
WORD d0;
{
	static int x,y;

	if (d0 == 0)
	{
		if (in_status)
			gotoXY(x,y);

		in_status = 0;
	}
	else if(d0 == 1)
	{
		if (!in_status)
			storeXY(&x, &y);

		in_status = 1;
		gotoXY(0,1);
	}
}

/************************************************************************/
/*			main interpreter loop				*/

void (*class0[])() = {
	ret_1,			/* op 0xb0	*/
	ret_0,			/* op 0xb1	*/
	print_im,			/* op 0xb2	*/
	printcr_im,			/* op 0xb3	*/
	nop,			/* op 0xb4	*/
	save_g,			/* op 0xb5	*/
	restore_g,		/* op 0xb6	*/
	restart_g,		/* op 0xb7	*/
	ret_sp,			/* op 0xb8	*/
	inc_sp,			/* op 0xb9	*/
	halt,			/* op 0xba	*/
	newline,		/* op 0xbb	*/
	status,			/* op 0xbc	*/
	verify,			/* op 0xbd	*/
	illegal,		/* op 0xbe	*/
	illegal			/* op 0xbf	*/
};

void (*class1[])() = {
	bne,
	l1190c,
	l118f2,
	l118e4,
	l11a7e,
	l11aac,
	l11aba,
	print_near,
	illegal,
	l118a2,
	l11e24,
	ret,
	bra,
	print_far,
	l11a96,
	not
};

struct {
	void (*func)();
	BYTE flag;
	} class2[] = {
		{ illegal,	1 },		/* 00 */
		{ l11824,	0 },		/* 01 */
		{ cbge,		1 },		/* 02 */
		{ cble,		1 },		/* 03 */
		{ dcbge,	1 },		/* 04 */
		{ icble,	1 },		/* 05 */
		{ l11926,	1 },		/* 06 */
		{ l11806,	1 },		/* 07 */
		{ or,		1 },		/* 08 */
		{ and,		1 },		/* 09 */
		{ tstbit_jz,	1 },		/* 0a */
		{ setbit,	1 },		/* 0b */
		{ clrbit,	1 },		/* 0c */
		{ l11a9e,	1 },		/* 0d */
		{ l1187c,	1 },		/* 0e */
		{ l11a16,	1 },		/* 0f */
		{ l11a28,	1 },		/* 10 */
		{ l11936,	1 },		/* 11 */
		{ l11a54,	1 },		/* 12 */
		{ l119a4,	1 },		/* 13 */
		{ add,		1 },		/* 14 */
		{ sub,		1 },		/* 15 */
		{ mul,		1 },		/* 16 */
		{ div,		1 },		/* 17 */
		{ mod,		1 },		/* 18 */
		{ illegal,	1 },		/* 19 */
		{ illegal,	1 },		/* 1a */
		{ illegal,	1 },		/* 1b */
		{ illegal,	1 },		/* 1c */
		{ illegal,	1 },		/* 1d */
		{ illegal,	1 },		/* 1e */
		{ illegal,	1 },		/* 1f */
		{ call,	0 },			/* 20 */
		{ l11a38,	1 },		/* 21 */
		{ l11a48,	1 },		/* 22 */
		{ l1196e,	1 },		/* 23 */
		{ input,	0 },		/* 24 */
		{ l11dcc,	1 },		/* 25 */
		{ write_num,	1 },		/* 26 */
		{ rnd,		1 },		/* 27 */
		{ l11aa2,	1 },		/* 28 */
		{ l11aa6,	1 },		/* 29 */
		{ l11e5e,	1 },		/* 2a */
		{ l11e7e,	1 },		/* 2b */
		{ illegal,	1 },		/* 2c */
		{ illegal,	1 },		/* 2d */
		{ illegal,	1 },		/* 2e */
		{ illegal,	1 },		/* 2f */
		{ illegal,	1 },		/* 30 */
		{ illegal,	1 },		/* 31 */
		{ illegal,	1 },		/* 32 */
		{ illegal,	1 },		/* 33 */
		{ illegal,	1 },		/* 34 */
		{ illegal,	1 },		/* 35 */
		{ illegal,	1 },		/* 36 */
		{ illegal,	1 },		/* 37 */
		{ illegal,	1 },		/* 38 */
		{ illegal,	1 },		/* 39 */
		{ illegal,	1 },		/* 3a */
		{ illegal,	1 },		/* 3b */
		{ illegal,	1 },		/* 3c */
		{ illegal,	1 },		/* 3d */
		{ illegal,	1 },		/* 3e */
		{ illegal,	1 }		/* 3f */
};

int oc;
int o1;

void run()
{
	register UWORD d0, d1, d2, d3, d4;
	register UWORD *argp, *bp;
	UWORD args[6];
	UWORD bits[4];

	argp = args;
	for(;;)
	{
#ifdef DEBUG
		ops[ops_ix].c_pc.offset = pc.offset;
		ops[ops_ix].c_pc.segment = pc.segment;
		ops[ops_ix].c_sp = sp - stack;
		ops[ops_ix].c_fp = framep - stack;
		ops[ops_ix].c_op = d0 = fetchb_op();
		ops_ix = (ops_ix + 1) & 0xff;
#else
		d0 = fetchb_op();
#endif
		if (d0 < 0x80)
		{
			d1 = l116b2((d0 & 0x40)?2:1);
			d2 = l116b2((d0 & 0x20)?2:1);

			if (class2[d0 & 0x1f].flag)
				(*class2[d0 & 0x1f].func)(d1, d2);
			else
			{
				argp[0] = 2;
				argp[1] = d1;
				argp[2] = d2;
				(*class2[d0 & 0x1f].func)(argp);
			}
		}
		else if (d0 < 0xb0)
			(*class1[d0 & 0x0f])(l116b2((d0 >> 4) & 0x03));
		else if (d0 < 0xc0)
			(*class0[d0 & 0x0f])();
		else
		{
			d2 = d0;
			bp = &bits[4];
			d0 = fetchb_op();
			*(--bp) = d0;
			*(--bp) = (d0 >>= 2);
			*(--bp) = (d0 >>= 2);
			*(--bp) = (d0 >>= 2);
			for (d4 = 0, d3 = 4; d3; d3--)
			{
				if ((d0 = *(bp++) & 3) == 3)
					break;
				argp[++d4] = l116b2(d0);
			}
			argp[0] = d4;

			if (class2[d2 & 0x3f].flag)
				(*class2[d2 & 0x3f].func)
					(argp[1],argp[2],argp[3],argp[4]);
			else
				(*class2[d2 & 0x3f].func)(argp);
		}
	}
}
	
/************************************************************************/
/*				initializiation				*/
no_mem_error()
{
	fatal("Out of memory", NULL);
}

main(argc,argv)
int argc; char **argv;
{
	struct header h;
	register BYTE *p, *q, *r;
	register int i;

	char space[128];
	extern int optind;
	extern char *optarg;
	char *usage;

	int c, sflag, rflag;
	char *restore_name;
	char *strchr(), *strrchr();

# if defined(OSK)
	usage = "\15\12Usage:\tzmachine [ -p protocolfile ] [ -w protocol linewith ]\
\15\12\t[ -s storyfile ] [ -r restorefile ] [ <storyfile>.dat ]\
\15\12\t[ <restorefile>.sav ]\15\12";
# else
	usage = "\r\nUsage:\tzmachine [ -p protocolfile ] [ -w protocol linewith ]\
\r\n\t[ -s storyfile ] [ -r restorefile ] [ <storyfile>.dat ]\
\r\n\t[ <restorefile>.sav ]\r\n";
# endif

	story_name = restore_name = NULL;

	sflag = rflag = 0;
	while ((c = getopt(argc, argv, "s:p:r:w:")) != EOF)
	{
		switch(c)
		{
			case 's':
				story_name = optarg;
				sflag++;
				break;

			case 'p':
				print_name = optarg;
				break;

			case 'r':
				restore_name = optarg;
				rflag++;
				break;

			case 'w':
				if (!(printer_width = atoi(optarg)))
					printer_width = 80;
				break;

			default:
				write(2, usage, strlen(usage));
				exit(userexit(1));
		}
	}

	while (optind < argc)
	{
		char *tmp;

		if ((tmp = strrchr(argv[optind],'.')) &&
			(!strcmp(tmp,".dat") || !strcmp(tmp, ".DAT")))
			story_name = argv[optind];
		else if (tmp && (!strcmp(tmp, ".sav") || !strcmp(tmp, ".SAV")))
		{
			rflag++;
			restore_name = argv[optind];
		}
		else
		{
			fatal("Unknown filetype", argv[optind]);
		}
		optind++;
	}


	if (!story_name && restore_name && strchr(restore_name,'.'))
	{
		strcpy(space, restore_name);
		strcpy(strchr(space, '.'), ".dat");
		if (access(space,0))
			story_name = "story.dat";
		else
			story_name = space;
	}

	if (!story_name)
		story_name = "story.dat";

	if (open_story())
		fatal("Can't open", story_name);

	read_header(&h);

	if (h.zmachine != 3)
		fatal("Wrong Z-machine version", story_name);

	mmu_init(&h);

	read_story(0, main_l, main_p);

	in_status = 0;
	
	release = word_get(h.release);

	status_type = (h.flags & 2) >> 1;

	ff0 = main_p + word_get(h.reserved2);
	fec = main_p + word_get(h.reserved3);
	short_cuts = main_p + word_get(h.short_cuts);
	save_len = btop((long)word_get(h.save_len));
	if (!(stack = (UWORD *)malloc(0x100 * sizeof(WORD))))
		no_mem_error();

	printer = init_dev(prot_write, prot_crlf, printer_width, 0, 0);

	if (!(terms = malloc(0x40)))
		no_mem_error();

	q = main_p + word_get(h.vocabulary);
	for(p = (BYTE *)terms, i = *(q++); i; i--)
		*p++ = *q++;		/* copy terminators	*/

	my_terms = (char *)p;
	for(r = (BYTE *)" \011\015.,?"; *p++ = *r++;)
		;			/* copy my terminators	*/

	word_len = *q++;		/* word-len		*/
	word_num = word_get(q);		/* number of words	*/
	q += 2;

	first_word = q;			/* start of words	*/
	last_word = (word_num - 1) * word_len + first_word;
					/* end of words		*/

	if (setjmp(restart_buf))
	{
		rflag = 0;
		i = word_get(main_h->reserved5);
		read_story(0, save_len, main_p);
		word_put(main_h->reserved5, i);
	}

	printer->bp = printer->buffer;
	printer->count = 0;
	main_h->flags |= 32;

	status_len = 1;
	init_con();
	if (!rflag)
	{
		sp = &stack[0x100];
		framep = sp - 1;
		baddr_to_vaddr(&pc, word_get(h.initial_pc));
		load_code();
	}
	else
	{
		if (restore_gf(restore_name))
			jump(1);
		else
			fatal("Cannot load restore file", restore_name);
	}
	run();
}
