/* move2.c */

/* Author:
 *	Steve Kirkendall
 *	16820 SW Tallac Way
 *	Beaverton, OR 97006
 *	kirkenda@jove.cs.pdx.edu, or ...uunet!tektronix!psueea!jove!kirkenda
 */


/* This function contains the mvoement functions that perform RE searching */

#include "vi.h"
#include "regexp.h"

static regexp	*re;	/* compiled version of the pattern to search for */
static		prevsf;	/* boolean: previous search direction was forward? */

MARK	movensrch(m)
	MARK	m;	/* where to start searching */
{
	if (prevsf)
	{
		m = movefsrch(m, "");
		prevsf = TRUE;
	}
	else
	{
		m = movebsrch(m, "");
		prevsf = FALSE;
	}
	return m;
}

MARK	moveNsrch(m)
	MARK	m;	/* where to start searching */
{
	if (prevsf)
	{
		m = movebsrch(m, "");
		prevsf = TRUE;
	}
	else
	{
		m = movefsrch(m, "");
		prevsf = FALSE;
	}
	return m;
}

MARK	movefsrch(m, ptrn)
	MARK	m;	/* where to start searching */
	char	*ptrn;	/* pattern to search for */
{
	long	l;	/* line# of line to be searched */
	char	*line;	/* text of line to be searched */

	/* remember: "previous search was forward" */
	prevsf = TRUE;

	if (ptrn && *ptrn)
	{
		/* free the previous pattern */
		if (re) free(re);

		/* compile the pattern */
		re = regcomp(ptrn);
		if (!re)
		{
			return MARK_UNSET;
		}
	}
	else if (!re)
	{
		msg("No previous expression");
		return MARK_UNSET;
	}

	/* search forward for the pattern */
	for (l = markline(m) + 1; l != markline(m); l++)
	{
		/* wrap search */
		if (l > nlines)
		{
			if (*o_wrapscan)
			{
				l = 0;
				continue;
			}
			else
			{
				break;
			}
		}

		/* get this line */
		line = fetchline(l);

		/* check this line */
		if (regexec(re, line, 1))
		{
			/* match! */
			return MARK_AT_LINE(l) + (re->startp[0] - line);
		}
	}

	/* not found */
	msg(*o_wrapscan ? "Not found" : "Hit bottom without finding RE");
	return MARK_UNSET;
}

MARK	movebsrch(m, ptrn)
	MARK	m;	/* where to start searching */
	char	*ptrn;	/* pattern to search for */
{
	long	l;	/* line# of line to be searched */
	char	*line;	/* text of line to be searched */

	/* remember: "previous search was not forward" */
	prevsf = FALSE;

	if (ptrn && *ptrn)
	{
		/* free the previous pattern, if any */
		if (re) free(re);

		/* compile the pattern */
		re = regcomp(ptrn);
		if (!re)
		{
			return MARK_UNSET;
		}
	}
	else if (!re)
	{
		msg("No previous expression");
		return MARK_UNSET;
	}

	/* search backward for the pattern */
	for (l = markline(m) - 1; l != markline(m); l--)
	{
		/* wrap search */
		if (l < 1)
		{
			if (*o_wrapscan)
			{
				l = nlines + 1;
				continue;
			}
			else
			{
				break;
			}
		}

		/* get this line */
		line = fetchline(l);

		/* check this line */
		if (regexec(re, line, 1))
		{
			/* match! */
			return MARK_AT_LINE(l) + (re->startp[0] - line);
		}
	}

	/* not found */
	msg(*o_wrapscan ? "Not found" : "Hit top without finding RE");
	return MARK_UNSET;
}

