/* MINIX is copyright 1989 Prentice-Hall, Inc. */

/* The <ansi.h> header defines two macros that can be tested to determine
 * whether prototypes should be included in the other header files.  Three
 * cases are relevant:
 *
 *	_USE_ANSI_PROTOTYPES	- Use ANSI C prototypes
 *	_USE_OLD_PROTOTYPES	- Use traditional Kernighan & Ritchie style
 *	(neither)		- No prototypes (when compiling the kernel)
 *
 * Note that K & R prototypes may be omitted for functions returning 'int'.
 */

/* _ANSI_H defined the first time this file is included. */
#ifndef _ANSI_H
#define _ANSI_H
#endif

/* ANSI C requires __STDC__ to be defined as 1 for an ANSI C compiler.
 * Some half-ANSI compilers define it as 0.  Get around this here.
 */

#define _USE_ANSI_PROTOTYPES 0	/* 0 means do not use ANSI C prototypes */
#define _USE_OLD_PROTOTYPES  0	/* 0 means do not use K & R prototypes */

#ifndef _KERNEL			/* if _KERNEL is defined, leave them 0 */

#ifdef __STDC__			/* __STDC__ defined for (near) ANSI compilers*/
#if __STDC__ == 1		/* __STDC__ == 1 for conformant compilers */
#undef _USE_ANSI_PROTOTYPES	/* get rid of old definition (0) */
#define _USE_ANSI_PROTOTYPES 1	/* install new definition (1) */
#endif
#endif

#endif

/* When installing this file on your system, you might consider making a
 * backup of it, and then removing all the comments from the original to speed
 * up compilation, as this file is included a great deal.
 */
