/* dial.c
 * written by bob best (bob@dhw68k.cts.com)
 * 
 * supports Hayes compatible modems
 * Usage: dial device telno baudrate
 * 
 * this program is called by the 'dialer' shell script that is part
 * of the zterm package posted to comp.os.minix
 */
#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <sgtty.h>

#define	FAIL    1
#define	SUCCESS	0
#define BUFLINE	256	
#define CMDLINE	80
#define TIMEOUT	30

char *strchr();
int alarmsig();
int fd;

main(argc,argv)
	int argc;
	char *argv[];
{
	char *device;
	char *telno;
	char cmdbuf[CMDLINE];
	int timeout, baudrate;
	char *p;
	struct sgttyb sgtty;

	device = argv[1];
	telno = argv[2];
/*	baudrate = atoi(argv[3]);*/
	switch(atoi(argv[3])) {
	case 1200:
		baudrate=B1200;
		break;
	case 2400:
		baudrate=B2400;
		break;
	case 9600:
		baudrate=B9600;
		break;
	default:
		printf("Bad baudrate %s - exiting\r\n",argv[3]);
		exit(1);
	}	
	if ((fd = open(device, O_RDWR)) < 0) {
		printf("dial: Can't open device: %s\n", device);
		exit(FAIL);
	}

	ioctl(fd, TIOCGETP, &sgtty);
	sgtty.sg_ispeed = baudrate;
	sgtty.sg_ospeed = baudrate;
	ioctl(fd, TIOCSETP, &sgtty);
	sleep(1);
	write(fd,"AT\r",3);
	sleep(2);
	sprintf(cmdbuf, "ATDT%s\r", telno);
	timeout = TIMEOUT;
	signal(SIGALRM, alarmsig);
	p=cmdbuf;
	while (*p)
		write(fd, p++, 1);
	if (getmodem(timeout))
		exit(FAIL);
	else
		exit(SUCCESS);
}

getmodem(timer)
	int timer;
{
	char c;
	register char *p;
	char buf[BUFLINE];

	p = buf;
	alarm(timer);
	while (read(fd, &c, 1) == 1) {
		*p++ = c;
		if (p >= buf + BUFLINE) {
			alarm(0);
			return(FAIL);
		}
		if (c == '\r') {
			if (getCONNECT(buf) == SUCCESS) {
				alarm(0);
				return(SUCCESS);
			}
			p=buf; /* reset pointer for next string */
		}
	}
	alarm(0);
	return(FAIL);
}

getCONNECT(l)
	register char *l;
{
	int len = strlen("CONNECT");

	while ((l = strchr(l, 'C')) != NULL) {
		if (strncmp("CONNECT", l, len) == 0)
			return(SUCCESS);
		l++;
	}
	return(FAIL);
}

alarmsig()
{
	exit(FAIL);
}
