/*
 * W-NEWS	A simple NEWS processing package for MINIX.
 *
 *		N e w s   P a c k a g e   D e f i n i t i o n s
 *
 * Author:	Fred N. van Kempen, MicroWalt Corporation
 */

/* First of all, some configuration parameters. */
#define HAVE_WALT  1			/* are we standalone W-NEWS?	*/
#define HAVE_ESTD  0			/* do we have Estdio(3) ??	*/
#define HAVE_HIST  1			/* do we want the hist stuff?	*/
#define HAVE_ACCT  0			/* do we want the accounting?	*/
#define HAVE_AUTO  1			/* automatic control messages?	*/

/* Then, some system defaults. You can change them. */
#define UUCPNAME   "/etc/uucpname"	/* my UUCP system name		*/
#define DFLT_TZ	   "+0100"		/* dflt TizeZone (ARPA fmt)	*/
#define DFLT_NEWSG "mugnet.talk"	/* dflt newsgroup (pnews)	*/
#define DFLT_DIST  "world"		/* dflt distribution (pnews)	*/
#define BATCHDIR   "/usr/spool/batch"	/* where news batches are	*/
#define LIBDIR     "/usr/lib/news"	/* the NEWS system directory	*/
#define SPOOLDIR   "/usr/spool/news"	/* where news articles are	*/

/* It should not be necessary to change these. */
#define BATCHLIM   50000		/* maxsize of a batch		*/
#define USENET     "usenet"		/* NEWS administrator		*/

/* Pathnames of the used system programs. You can change them. */
#define MAIL       "/usr/bin/mail"	/* the local mailer		*/
#define COMPRESS   "/usr/bin/compress"	/* compress(1) program		*/
#define UUX     "/usr/bin/uux -r -gd -"	/* UUX command line		*/
#define SHELL      "/bin/sh"		/* the shell program		*/
#define SYSRM      "/bin/rm"		/* the rm(1) program		*/
#define E_EDIT     "/usr/bin/edit"	/* line editor			*/
#define V_EDIT     "/usr/bin/vi"	/* screen editor		*/

/* User file names; should not need any changes. */
#define SIGNATURE  ".signature"		/* user signature file		*/
#define DEADART	   "dead.article"	/* user zombie article		*/
#define NEWSRC     ".newsrc"		/* news agenda			*/

/* NEWS system file names; should not need any changes. */
#define ACCTFILE   "news.adm"		/* NEWS "resource accouting"	*/
#define ACTIVE     "active"		/* NEWS "active" file		*/
#define BATLOCK    ".batlock"		/* sendbatch is running		*/
#define DISTRIBS   "distributions"	/* possible distributions	*/
#define ERRLOG     "errlog"		/* NEWS "error log" file	*/
#define HISTFILE   "history"		/* NEWS "history" file		*/
#define LOGFILE    "log"		/* NEWS "system log" file	*/
#define NGROUPS    "newsgroups"		/* existing newsgroups		*/
#define ORGANIZAT  "organization"	/* my organization name		*/
#define SYSFILE    "sys"		/* NEWS "sys" file		*/
#define UNBLOCK    ".unblock"		/* unbatch is running		*/

/* NEWS system dirctory names; should not need any changes. */
#define CONTROL    "control"		/* control messages		*/
#define INCOMING   ".rnews"		/* incoming news batches	*/
#define JUNK       "junk"		/* disaster newsgroup		*/

#define COMPRHDR   "#! cunbatch\n"	/* 'compress' indicator		*/
#define RNEWSHDR   "#! rnews "		/* article separator header	*/
