#! /bin/sh
#
# W-NEWS	A simple NEWS processing package for MINIX.
#		This is a shell script to ease the installation of the
#		W-NEWS package on your system. See the README file for
#		installation details.
#
# Usage:	Install {progs}
#
# Version:	3.00	03/30/91
#
# Author:	Fred N. van Kempen, MicroWalt Corporation
#

# Constants.
UNAME=news
GNAME=news
USENET=usenet
UID=30
GID=30
UUCPNAME=/etc/uucpname
LIB=/usr/lib/news
SPL=/usr/spool/news
BAT=/usr/spool/batch

# Might also be /usr/ucb or /usr/local/bin .
BIN=/usr/bin

# Absolute names are faster!
ECHO=/bin/echo
EXPR=/usr/bin/expr
TEST=/usr/bin/[

  # Variables.
  ans=
  progs=
  sysname=
  domname=
  dir=
  group=
  first=
  last=
  maypost=

  clr;
  ${ECHO} "This procedure installs the W-NEWS package onto your system."
  ${ECHO} "It does this by asking you questions, and checking the answers"
  ${ECHO} "against some files on your system disk."
  ${ECHO}

  # Check procedure arguments.
  if ${TEST} "$#" != "0" ]
  then
	progs="$*"
  else
	progs=
  fi

  # Check the UUCP system information.
  if ${TEST} ! -f ${UUCPNAME} ]
  then
	${ECHO} "Please install the UUCP system first!"
	exit 1
  fi
  set `cat ${UUCPNAME}`
  sysname="$1"
  domname="$2"
  if ${TEST} "$#" != "2" ]
  then
	${ECHO} "It seems that your ${UUCPNAME} file is incomplete."
	${ECHO} -n "Please enter your UUCP name \[${sysname}\]: "
	read ans
	if ${TEST} -n "${ans}" ]
	then
		sysname="${ans}"
	fi
	${ECHO} -n "Please enter your domain name [uucp]: "
	read ans
	domname="uucp"
	if ${TEST} -n "${ans}" ]
	then
		domname="${ans}"
	fi

	(${ECHO} ${sysname}; ${ECHO} ${domname}) > ${UUCPNAME}
	${ECHO} "Updated ${UUCPNAME}."
  else
	${ECHO} "Your ${UUCPNAME} file contains the correct information."
  fi
  ${ECHO}
  ${ECHO} "Your system will be called \"${sysname}.${domname}\" ."
  ${ECHO}

  # Check and update /etc/passwd and /etc/group.
  ${ECHO} "Checking /etc/passwd and /etc/group..."
  if grep -s ${UNAME} /etc/passwd &&
     grep -s ${USENET} /etc/passwd
  then
	${ECHO} "	Your /etc/passwd file is OK."
  else
	${ECHO} -n "Do you want me to update /etc/passwd? y/n "
	read ans
	if ${TEST} "${ans}" = "y" ]
	then
		${ECHO} "	Updating /etc/passwd."
		${ECHO} "${UNAME}:*:${UID}:${GID}:W-NEWS System:${LIB}:" >>/etc/passwd
		${ECHO} "${USENET}:*:`expr ${UID} + 1`:${GID}:W-NEWS Administrator:${LIB}:" >>/etc/passwd
	fi
  fi
  if grep -s ${GNAME} /etc/group
  then
	${ECHO} "	Your /etc/group file is OK."
  else
	${ECHO} -n "Do you want me to update /etc/group? y/n "
	read ans
	if ${TEST} "${ans}" = "y" ]
	then
		${ECHO} "	Updating /etc/group."
		${ECHO} "${GNAME}:*:${GID}:" >>/etc/group
	fi
  fi
  ${ECHO}

  ${ECHO} -n "Do you want me to re-create the \"${LIB}\" directory? y/n "
  read ans
  if ${TEST} "${ans}" = "y" ]
  then
	${ECHO} "Creating directory..."
	rm -rf ${LIB}
	mkdir ${LIB}
  fi
  ${ECHO}

  ${ECHO} -n "Do you want me to re-create all \"news\" files? y/n "
  read ans
  if ${TEST} "${ans}" = "y" ]
  then
	${ECHO} "Clearing directory ${LIB}..."
	rm -f ${LIB}/*
	${ECHO} "Copying files..."
	cp sys active newsgroups distributions ${LIB}
	cp ${progs} ${LIB}
	touch ${LIB}/errlog ${LOG}/log
  else
	${ECHO} "Checking files..."
	for i in sys active newsgroups distributions
	do
		if ${TEST} -f ${LIB}/$i ]
		then
			${ECHO} "	${LIB}/$i OK."
		else
			${ECHO} "	Creating default ${LIB}/$i"
			cp $i ${LIB}
		fi
	done
	for i in ${progs}
	do
		${ECHO} "	Copying $i to ${LIB}/$i"
		cp $i ${LIB}
	done
	cp /dev/null ${LIB}/errlog
	cp /dev/null ${LOG}/log
  fi
  if ${TEST} -f ${LIB}/organization ]
  then
	${ECHO} "	Organization name OK."
  else
	${ECHO} "	Enter organization name. Keep it short!"
	${ECHO} -n "> "
	read ans
	if ${TEST} -n "${ans}" ]
	then
		${ECHO} ${ans} > ${LIB}/organization
	else
		cp /dev/null ${LIB}/organization
	fi
  fi
  ${ECHO}

  ${ECHO} -n "Do you want me to re-create the \"${SPL}\" directory? y/n "
  read ans
  if ${TEST} "${ans}" = "y" ]
  then
	${ECHO} "Creating directories..."
	rm -rf ${SPL}
	mkdir ${SPL} ${BAT} ${SPL}/control ${SPL}/junk ${SPL}/.rnews
	upddir=yes
  else
	${ECHO} "Checking directories..."
	if ${TEST} -d ${SPL}/.rnews ]
	then
		${ECHO} "	${SPL}/.rnews OK."
	else
		${ECHO} "	Creating ${SPL}/.rnews"
		mkdir ${SPL}/.rnews
	fi
	if ${TEST} -d ${BAT} ]
	then
		${ECHO} "	${BAT} OK."
	else
		${ECHO} "	Creating ${BAT}"
		mkdir ${BAT}
	fi
	upddir=no
  fi
  ${ECHO}

  if ${TEST} "${upddir}" = "yes" ]
  then
	${ECHO} "Creating a list of spool directories. This may take time!"
	${ECHO} >DIRLIST
	cat ${LIB}/active |
		(while read group last first maypost
		do
			${ECHO} ${group}
		done) | tr . / | (while read dir
			do
				${ECHO} ${SPL}/${dir} >>DIRLIST
			done)

	${ECHO} "Spool directories created. See DIRLIST for the list!"
  fi

  ${ECHO} "Setting up links..."
  rm -f ${BIN}/pnews ${BIN}/rnews ${BIN}/checknews \
	${LIB}/checkgroups ${LIB}/newgroup ${LIB}/rmgroup ${LIB}/cancel \
	${LIB}/sendsys ${LIB}/senduuname ${LIB}/version
  ln ${LIB}/pnews ${BIN}/pnews
  ln ${LIB}/rnews ${BIN}/rnews
  ln ${LIB}/checknews ${BIN}/checknews
  ln ${LIB}/control ${LIB}/checkgroups
  ln ${LIB}/control ${LIB}/newgroup
  ln ${LIB}/control ${LIB}/rmgroup
  ln ${LIB}/control ${LIB}/cancel
  ln ${LIB}/control ${LIB}/sendsys
  ln ${LIB}/control ${LIB}/senduuname
  ln ${LIB}/control ${LIB}/version
  ${ECHO}

  ${ECHO} "Setting up permissions..."
  chmod 755 ${LIB} ${SPL} ${SPL}/control ${SPL}/junk
  chmod 750 ${BAT} ${SPL}/.rnews
  chmod 6550 ${LIB}/unbatch ${LIB}/sendbatch ${LIB}/expire ${LIB}/control
  chmod 6555 ${LIB}/inews ${LIB}/rnews
  chmod 555 ${LIB}/pnews ${LIB}/checknews
  chmod 644 ${LIB}/active ${LIB}/distributions ${LIB}/newsgroups \
	${LIB}/organization
  chown ${UNAME}.${GNAME} ${LIB} ${SPL} ${BAT} ${LIB}/* ${SPL}/control \
	${SPL}/junk ${SPL}/.rnews
  ${ECHO}

  ${ECHO} "Installation done."
  ${ECHO} "W-NEWS has now been installed on your system !!"

  exit 0
