#!/bin/sh

##
##  name:       uutry
##
##  version:    1.2
##
##  author:     paul@max.uk.mugnet.org, paul@ukpoit.co.uk
##              Copyright 1991 by Paul Wood, Sheffield, UK
##
##  purpose:    attempt to call a system and start up any uucp transfers
##              which are currently queued on either system
##
##              upto three attempts will be made
##
##              normally called by a user to check the uucp configuration
##              and the communications functionality
##
##              usage:
##                  uutry [-x<debug>] <system>
##
##              where:
##                  <debug> is the debug level, default level 1
##                  <system> is the name of the system
##
##              eg:
##                  uutry -x5 scud
##


##
##  constants
##
UUCP="/usr/lib/uucp"                    ##  name of the UUCP home directory
SPOOL="/usr/spool/uucp"                 ##  name of the UUCP spool directory
UUCICO="${UUCP}/uucico"                 ##  path to the UUCP uucico program
UUCLEAN="${UUCP}/uuclean"		##  path to the UUCP uuclean program
UNGETTY="/etc/ungetty"                  ##  path to the ungetty program
USAGE="uutry [-x<debug>] <system>"      ##  usage text
MODEM="tty1"                            ##  modem port

##
##  variables
##
DEBUG="1"                               ##  debug level to be used
SYSTEM=""                               ##  system name to be polled

##
##  amend PATH to include /usr/lib/uucp
##
PATH="${UUCP}:${PATH}"

##
##  extract the debug and system parameters
##
case $1 in
    -x[1-9] )
        if [ $# -ne 2 ]
        then
            echo "uutry: aborted."
            echo "uutry: usage: ${USAGE}"
            exit 1
        fi
        DEBUG=`echo $1 | cut -c3`
        shift 1
        ;;
    -x1[0-2] )
        if [ $# -ne 2 ]
        then
            echo "uutry: aborted."
            echo "uutry: usage: ${USAGE}"
            exit 1
        fi
        DEBUG=`echo $1 | cut -c3-4`
        shift 1
        ;;
    * )
        if [ $# -ne 1 ]
        then
            echo "uutry: aborted."
            echo "uutry: usage: ${USAGE}"
            exit 1
        fi
        ;;
esac
SYSTEM=$1

##
##  remove unused lock files
##
${UUCLEAN} >/dev/null 2>&1

##
##  check whether modem is currently in use
##       
if [ -f "${SPOOL}/LCK..${MODEM}" ]
then
    echo "uutry: modem line ${MODEM} is currently in use"
    echo "uutry: aborted"
    exit 1
fi

##
##  warn about any lock files
##
for FILE in ${SPOOL}/LCK..* ${SPOOL}/LCK.*
do
    if [ -f ${FILE} ]
    then
        echo "uutry: WARNING: lock file ${FILE} exists"
    fi
done

##
##  if the ungetty feature is available, suspend the uugetty and
##  get control of the tty
##       
if [ -f "${UNGETTY}" ]
then
    ${UNGETTY} -o ${MODEM} >/dev/null 2>&1
    ##
    ##  if ungetty fails to get control of the tty, abort uutry
    ##
    if [ $? -ne 0 ]
    then
        echo "uutry: failed to get control of the tty"
        exit 1
    fi
fi

##
##  start up the uucico program
##
${UUCICO} -s${SYSTEM} -x${DEBUG}

##
##  if ungetty is available, resume the suspended uugetty
##
if [ -f "${UNGETTY}" ]
then
    ${UNGETTY} -i ${MODEM}
fi

##
##  end of uutry
##

